/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.GaussianFittingFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.LevenbergMarquardtMethod;
import de.lmu.ifi.dbs.elki.math.statistics.KernelDensityEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Arrays;

public class NormalLevenbergMarquardtKDEEstimator
implements DistributionEstimator<NormalDistribution> {
    public static final NormalLevenbergMarquardtKDEEstimator STATIC = new NormalLevenbergMarquardtKDEEstimator();

    private NormalLevenbergMarquardtKDEEstimator() {
    }

    @Override
    public <A> NormalDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        MeanVariance meanVariance = new MeanVariance();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = numberArrayAdapter.getDouble(a, i);
            meanVariance.put(dArray[i]);
        }
        Arrays.sort(dArray);
        double d = (dArray[n >> 1] + dArray[n + 1 >> 1]) * 0.5;
        KernelDensityEstimator kernelDensityEstimator = new KernelDensityEstimator(dArray, GaussianKernelDensityFunction.KERNEL, 1.0E-6);
        double[] dArray2 = kernelDensityEstimator.getDensity();
        double[] dArray3 = new double[n];
        Arrays.fill(dArray3, 1.0);
        double[] dArray4 = new double[]{d, meanVariance.getSampleStddev(), 1.0};
        boolean[] blArray = new boolean[]{true, true, false};
        LevenbergMarquardtMethod levenbergMarquardtMethod = new LevenbergMarquardtMethod(GaussianFittingFunction.STATIC, dArray4, blArray, dArray, dArray2, dArray3);
        levenbergMarquardtMethod.run();
        double[] dArray5 = levenbergMarquardtMethod.getParams();
        return new NormalDistribution(dArray5[0], dArray5[1]);
    }

    @Override
    public Class<? super NormalDistribution> getDistributionClass() {
        return NormalDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected NormalLevenbergMarquardtKDEEstimator makeInstance() {
            return STATIC;
        }
    }
}

