/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J.R.M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report")
public class NormalLMMEstimator
extends AbstractLMMEstimator<NormalDistribution> {
    public static final NormalLMMEstimator STATIC = new NormalLMMEstimator();

    private NormalLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public NormalDistribution estimateFromLMoments(double[] dArray) {
        return new NormalDistribution(dArray[0], Math.max(dArray[1] * MathUtil.SQRTPI, Double.MIN_NORMAL));
    }

    @Override
    public Class<? super NormalDistribution> getDistributionClass() {
        return NormalDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected NormalLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

