/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J.R.M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report")
public class GammaLMMEstimator
extends AbstractLMMEstimator<GammaDistribution> {
    public static final GammaLMMEstimator STATIC = new GammaLMMEstimator();
    private static double A1 = -0.308;
    private static double A2 = -0.05812;
    private static double A3 = 0.01765;
    private static double B1 = 0.7213;
    private static double B2 = -0.5947;
    private static double B3 = -2.1817;
    private static double B4 = 1.2113;

    private GammaLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public GammaDistribution estimateFromLMoments(double[] dArray) {
        double d;
        double d2;
        double d3 = dArray[1] / dArray[0];
        if (d3 < 0.5) {
            d2 = Math.PI * d3 * d3;
            d = (1.0 + A1 * d2) / (d2 * (1.0 + d2 * (A2 + d2 * A3)));
        } else {
            d2 = 1.0 - d3;
            d = d2 * (B1 + d2 * B2) / (1.0 + d2 * (B3 + d2 * B4));
        }
        d2 = d / dArray[0];
        if (!(d > 0.0) || !(d2 > 0.0)) {
            throw new ArithmeticException("Gamma estimation produced non-positive parameter values: k=" + d + " theta=" + d2);
        }
        return new GammaDistribution(d, d2);
    }

    @Override
    public Class<? super GammaDistribution> getDistributionClass() {
        return GammaDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GammaLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

