/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Robust Estimators for Transformed Location Scale Families", authors="D. J. Olive", booktitle="")
public class ExponentialMedianEstimator
extends AbstractMADEstimator<ExponentialDistribution> {
    public static final ExponentialMedianEstimator STATIC = new ExponentialMedianEstimator();

    private ExponentialMedianEstimator() {
    }

    @Override
    public ExponentialDistribution estimateFromMedianMAD(double d, double d2) {
        double d3 = 1.441 * d;
        if (!(d3 > 0.0)) {
            throw new ArithmeticException("Data with non-positive mean cannot be exponential distributed.");
        }
        return new ExponentialDistribution(1.0 / d3);
    }

    @Override
    public Class<? super ExponentialDistribution> getDistributionClass() {
        return ExponentialDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ExponentialMedianEstimator makeInstance() {
            return STATIC;
        }
    }
}

