/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Alias(value={"log"})
public class LogisticDistribution
extends AbstractDistribution {
    double location;
    double scale;

    public LogisticDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    public LogisticDistribution(double d, double d2, Random random) {
        super(random);
        this.location = d;
        this.scale = d2;
    }

    public LogisticDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        this.location = d;
        this.scale = d2;
    }

    public static double pdf(double d, double d2, double d3) {
        d = Math.abs((d - d2) / d3);
        double d4 = Math.exp(-d);
        double d5 = 1.0 + d4;
        return d4 / (d3 * d5 * d5);
    }

    public static double logpdf(double d, double d2, double d3) {
        d = Math.abs((d - d2) / d3);
        double d4 = Math.exp(-d);
        double d5 = 1.0 + d4;
        return -(d + Math.log(d3 * d5 * d5));
    }

    @Override
    public double pdf(double d) {
        return LogisticDistribution.pdf(d, this.location, this.scale);
    }

    public static double cdf(double d, double d2, double d3) {
        d = (d - d2) / d3;
        return 1.0 / (1.0 + Math.exp(-d));
    }

    public static double logcdf(double d, double d2, double d3) {
        if ((d = (d - d2) / d3) <= 18.0) {
            return -Math.log1p(Math.exp(-d));
        }
        if (d > 33.3) {
            return d;
        }
        return d - Math.exp(d);
    }

    @Override
    public double cdf(double d) {
        return LogisticDistribution.cdf(d, this.location, this.scale);
    }

    public static double quantile(double d, double d2, double d3) {
        return d2 + d3 * Math.log(d / (1.0 - d));
    }

    public static double logquantile(double d, double d2, double d3) {
        return d2 + d3 * (d - MathUtil.log1mexp(-d));
    }

    @Override
    public double quantile(double d) {
        return LogisticDistribution.quantile(d, this.location, this.scale);
    }

    @Override
    public double nextRandom() {
        double d = this.random.nextDouble();
        return this.location + this.scale * Math.log(d / (1.0 - d));
    }

    @Override
    public String toString() {
        return "LogisticDistribution(location=" + this.location + ", scale=" + this.scale + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double location;
        double scale;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(SCALE_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.scale = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(LOCATION_ID))) {
                this.location = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LogisticDistribution makeInstance() {
            return new LogisticDistribution(this.location, this.scale, this.rnd);
        }
    }
}

