/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.algorithm.outlier.meta.HiCS;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.math.statistics.tests.GoodnessOfFitTest;
import de.lmu.ifi.dbs.elki.math.statistics.tests.KolmogorovSmirnovTest;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerComparator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Random;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. of the 2013 ACM International Conference on Management of Data (SIGMOD)", url="http://dx.doi.org/10.1145/2463676.2463696")
public class HiCSDependenceMeasure
extends AbstractDependenceMeasure {
    private int m = 50;
    private double alphasqrt = Math.sqrt(0.1);
    private GoodnessOfFitTest statTest;
    private RandomFactory rnd;

    public HiCSDependenceMeasure(GoodnessOfFitTest goodnessOfFitTest, int n, double d, RandomFactory randomFactory) {
        this.statTest = goodnessOfFitTest;
        this.m = n;
        this.alphasqrt = Math.sqrt(d);
        this.rnd = randomFactory;
    }

    @Override
    public <A, B> double dependence(final NumberArrayAdapter<?, A> numberArrayAdapter, final A a, final NumberArrayAdapter<?, B> numberArrayAdapter2, final B b) {
        double d;
        int n;
        int n2;
        int n3;
        int n4 = HiCSDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        int n5 = (int)((double)n4 * this.alphasqrt);
        Random random = this.rnd.getSingleThreadedRandom();
        int[] nArray = MathUtil.sequence(0, n4);
        int[] nArray2 = MathUtil.sequence(0, n4);
        IntegerArrayQuickSort.sort(nArray, new IntegerComparator(){

            @Override
            public int compare(int n, int n2) {
                return Double.compare(numberArrayAdapter.getDouble(a, n), numberArrayAdapter.getDouble(a, n2));
            }
        });
        IntegerArrayQuickSort.sort(nArray2, new IntegerComparator(){

            @Override
            public int compare(int n, int n2) {
                return Double.compare(numberArrayAdapter2.getDouble(b, n), numberArrayAdapter2.getDouble(b, n2));
            }
        });
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n5];
        double d2 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = numberArrayAdapter.getDouble(a, n3);
            if (dArray[n3] == dArray[n3]) continue;
            throw new AbortException("NaN values are not allowed by this implementation!");
        }
        n3 = this.m >> 1;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = random.nextInt(n4 - n5);
            n = 0;
            while (n < n5) {
                dArray2[n] = numberArrayAdapter2.getDouble(b, n6);
                ++n;
                ++n6;
            }
            d = this.statTest.deviation(dArray, dArray2);
            if (Double.isNaN(d)) {
                --n2;
                continue;
            }
            d2 += d;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            dArray[n2] = numberArrayAdapter2.getDouble(b, n2);
            if (dArray[n2] == dArray[n2]) continue;
            throw new AbortException("NaN values are not allowed by this implementation!");
        }
        for (n2 = n3; n2 < this.m; ++n2) {
            int n7 = random.nextInt(n4 - n5);
            n = 0;
            while (n < n5) {
                dArray2[n] = numberArrayAdapter.getDouble(a, n7);
                ++n;
                ++n7;
            }
            d = this.statTest.deviation(dArray, dArray2);
            if (Double.isNaN(d)) {
                --n2;
                continue;
            }
            d2 += d;
        }
        return d2 / (double)this.m;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private GoodnessOfFitTest statTest;
        private int m = 50;
        private double alpha = 0.1;
        private RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(HiCS.Parameterizer.M_ID, 50);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.m = intParameter.intValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(HiCS.Parameterizer.ALPHA_ID, 0.1);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(HiCS.Parameterizer.TEST_ID, (Class<?>)GoodnessOfFitTest.class, KolmogorovSmirnovTest.class))) {
                this.statTest = (GoodnessOfFitTest)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(randomParameter = new RandomParameter(HiCS.Parameterizer.SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected HiCSDependenceMeasure makeInstance() {
            return new HiCSDependenceMeasure(this.statTest, this.m, this.alpha, this.rnd);
        }
    }
}

