/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.SinCosTable;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="A. Tatu, G. Albuquerque, M. Eisemann, P. Bak, H. Theisel, M. A. Magnor, and D. A. Keim", title="Automated Analytical Methods to Support Visual Exploration of High-Dimensional Data", booktitle="IEEE Trans. Visualization and Computer Graphics, 2011", url="http://dx.doi.org/10.1109/TVCG.2010.242")
public class HSMDependenceMeasure
extends AbstractDependenceMeasure {
    public static final HSMDependenceMeasure STATIC = new HSMDependenceMeasure();
    private static final int STEPS = 48;
    private final int resolution = 512;
    private static final SinCosTable table = SinCosTable.make(48);

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        double d;
        double d2;
        int n;
        double d3;
        int n2 = HSMDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        boolean[][] blArray = new boolean[512][512];
        double d4 = d3 = numberArrayAdapter.getDouble(a, 0);
        for (n = 1; n < n2; ++n) {
            d2 = numberArrayAdapter.getDouble(a, n);
            if (d2 < d3) {
                d3 = d2;
                continue;
            }
            if (!(d2 > d4)) continue;
            d4 = d2;
        }
        double d5 = d3;
        double d6 = d4 > d3 ? 1.0 / (d4 - d3) : 1.0;
        d4 = d3 = numberArrayAdapter2.getDouble(b, 0);
        for (n = 1; n < n2; ++n) {
            d2 = numberArrayAdapter2.getDouble(b, n);
            if (d2 < d3) {
                d3 = d2;
                continue;
            }
            if (!(d2 > d4)) continue;
            d4 = d2;
        }
        double d7 = d3;
        double d8 = d4 > d3 ? 1.0 / (d4 - d3) : 1.0;
        for (int i = 0; i < n2; ++i) {
            double d9 = (numberArrayAdapter.getDouble(a, i) - d5) * d6;
            d = (numberArrayAdapter2.getDouble(b, i) - d7) * d8;
            HSMDependenceMeasure.drawLine(0, (int)(512.0 * d9), 511, (int)(512.0 * d), blArray);
        }
        int[][] nArray = this.houghTransformation(blArray);
        d = (double)this.sumMatrix(nArray) / 2304.0;
        int n3 = this.countAboveThreshold(nArray, d);
        return 1.0 - (double)n3 / 2304.0;
    }

    private long sumMatrix(int[][] nArray) {
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                l += (long)nArray2[j];
            }
        }
        return l;
    }

    private int countAboveThreshold(int[][] nArray, double d) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                if (!((double)nArray2[j] >= d)) continue;
                ++n;
            }
        }
        return n;
    }

    private int[][] houghTransformation(boolean[][] blArray) {
        int n = blArray.length;
        int n2 = blArray[0].length;
        double d = 24.0 / (double)(n + n2);
        int[][] nArray = new int[48][48];
        for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < blArray[0].length; ++j) {
                if (!blArray[i][j]) continue;
                for (int k = 0; k < 48; ++k) {
                    int n3 = 24 + (int)(d * ((double)i * table.cos(k) + (double)j * table.sin(k)));
                    if (n3 <= 0 || n3 >= 48) continue;
                    int[] nArray2 = nArray[n3];
                    int n4 = k;
                    nArray2[n4] = nArray2[n4] + 1;
                }
            }
        }
        return nArray;
    }

    private static void drawLine(int n, int n2, int n3, int n4, boolean[][] blArray) {
        int n5 = blArray.length;
        int n6 = blArray[0].length;
        int n7 = n2 < 0 ? 0 : (n2 = n2 >= n6 ? n6 - 1 : n2);
        int n8 = n4 < 0 ? 0 : (n4 = n4 >= n6 ? n6 - 1 : n4);
        int n9 = n < 0 ? 0 : (n = n >= n5 ? n5 - 1 : n);
        n3 = n3 < 0 ? 0 : (n3 >= n5 ? n5 - 1 : n3);
        int n10 = Math.abs(n3 - n);
        int n11 = n < n3 ? 1 : -1;
        int n12 = -Math.abs(n4 - n2);
        int n13 = n2 < n4 ? 1 : -1;
        int n14 = n10 + n12;
        while (true) {
            blArray[n][n2] = true;
            if (n == n3 && n2 == n4) break;
            int n15 = n14 << 1;
            if (n15 > n12) {
                n14 += n12;
                n += n11;
            }
            if (n15 >= n10) continue;
            n14 += n10;
            n2 += n13;
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HSMDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

