/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import java.util.List;

public abstract class AbstractSpatialSorter
implements SpatialSorter {
    @Override
    public <T extends SpatialComparable> void sort(List<T> list) {
        double[] dArray = AbstractSpatialSorter.computeMinMax(list);
        this.sort(list, 0, list.size(), dArray, null);
    }

    protected <T extends SpatialComparable> int pivotizeList1D(List<T> list, int n, int n2, int n3, double d, boolean bl) {
        int n4;
        d = 2.0 * d;
        int n5 = n;
        for (n4 = n2; n5 < n4; ++n5, --n4) {
            double d2;
            double d3;
            if (!bl) {
                d3 = this.getMinPlusMaxObject(list, n5, n3);
                while (d3 < d && n5 + 1 <= n4 && n5 + 1 < n2) {
                    d3 = this.getMinPlusMaxObject(list, ++n5, n3);
                }
                d2 = this.getMinPlusMaxObject(list, n4 - 1, n3);
                while (d2 >= d && n5 < n4 - 1 && n < n4 - 1) {
                    d2 = this.getMinPlusMaxObject(list, --n4 - 1, n3);
                }
            } else {
                d3 = this.getMinPlusMaxObject(list, n5, n3);
                while (d3 > d && n5 + 1 <= n4 && n5 + 1 < n2) {
                    d3 = this.getMinPlusMaxObject(list, ++n5, n3);
                }
                d2 = this.getMinPlusMaxObject(list, n4 - 1, n3);
                while (d2 <= d && n5 < n4 - 1 && n < n4 - 1) {
                    d2 = this.getMinPlusMaxObject(list, --n4 - 1, n3);
                }
            }
            if (n5 >= n4) {
                assert (n5 == n4);
                break;
            }
            list.set(n5, list.set(n4 - 1, list.get(n5)));
        }
        return n4;
    }

    private double getMinPlusMaxObject(List<? extends SpatialComparable> list, int n, int n2) {
        SpatialComparable spatialComparable = list.get(n);
        return spatialComparable.getMin(n2) + spatialComparable.getMax(n2);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] computeMinMax(List<? extends SpatialComparable> list) {
        int n = list.get(0).getDimensionality();
        double[] dArray = new double[n << 1];
        int n2 = 0;
        boolean n3 = false;
        while (n2 < n) {
            dArray[spatialComparable] = Double.POSITIVE_INFINITY;
            dArray[spatialComparable + true] = Double.NEGATIVE_INFINITY;
            ++n2;
            spatialComparable += 2;
        }
        for (SpatialComparable spatialComparable : list) {
            int n4 = 0;
            int n5 = 0;
            while (n4 < n) {
                dArray[n5] = Math.min(dArray[n5], spatialComparable.getMin(n4));
                dArray[n5 + 1] = Math.max(dArray[n5 + 1], spatialComparable.getMax(n4));
                ++n4;
                n5 += 2;
            }
        }
        int n6 = 0;
        boolean bl = false;
        while (n6 < n) {
            void var4_10;
            assert (dArray[var4_10] <= dArray[var4_10 + true]) : "Min > Max in dim " + n6 + ": " + dArray[var4_10] + " " + dArray[var4_10 + true];
            ++n6;
            var4_10 += 2;
        }
        return dArray;
    }
}

