/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.AbstractRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;
import java.util.Random;

@Reference(authors="L. Breiman", title="Bagging predictors", booktitle="Machine learning 24.2", url="http://dx.doi.org/10.1007/BF00058655")
public class RandomSubsetProjectionFamily
extends AbstractRandomProjectionFamily {
    public RandomSubsetProjectionFamily(RandomFactory randomFactory) {
        super(randomFactory);
    }

    @Override
    public RandomProjectionFamily.Projection generateProjection(int n, int n2) {
        int[] nArray;
        if (n2 < n) {
            nArray = Arrays.copyOf(RandomSubsetProjectionFamily.randomPermutation(MathUtil.sequence(0, n), this.random), n2);
        } else if (n2 == n) {
            nArray = RandomSubsetProjectionFamily.randomPermutation(MathUtil.sequence(0, n), this.random);
        } else {
            int n3;
            for (n3 = n; n3 < n2; n3 += n) {
            }
            nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = i % n;
            }
            nArray = Arrays.copyOf(RandomSubsetProjectionFamily.randomPermutation(nArray, this.random), n2);
        }
        return new SubsetProjection(nArray);
    }

    public static int[] randomPermutation(int[] nArray, Random random) {
        for (int i = nArray.length - 1; i > 0; --i) {
            int n = random.nextInt(i + 1);
            int n2 = nArray[n];
            nArray[n] = nArray[i];
            nArray[i] = n2;
        }
        return nArray;
    }

    public static class Parameterizer
    extends AbstractRandomProjectionFamily.Parameterizer {
        @Override
        protected RandomSubsetProjectionFamily makeInstance() {
            return new RandomSubsetProjectionFamily(this.random);
        }
    }

    public static class SubsetProjection
    implements RandomProjectionFamily.Projection {
        private int[] dims;

        public SubsetProjection(int[] nArray) {
            this.dims = nArray;
        }

        @Override
        public double[] project(NumberVector numberVector) {
            return this.project(numberVector, new double[this.dims.length]);
        }

        @Override
        public double[] project(NumberVector numberVector, double[] dArray) {
            for (int i = 0; i < this.dims.length; ++i) {
                dArray[i] = numberVector.doubleValue(this.dims[i]);
            }
            return dArray;
        }

        @Override
        public int getOutputDimensionality() {
            return this.dims.length;
        }
    }
}

