/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.AbstractCovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ChiSquaredDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Random;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Outlier Detection in Arbitrarily Oriented Subspaces", booktitle="Proc. IEEE International Conference on Data Mining (ICDM 2012)")
public class RANSACCovarianceMatrixBuilder
extends AbstractCovarianceMatrixBuilder {
    int iterations = 1000;
    RandomFactory rnd;

    public RANSACCovarianceMatrixBuilder(int n, RandomFactory randomFactory) {
        this.iterations = n;
        this.rnd = randomFactory;
    }

    @Override
    @Reference(title="Random sample consensus: a paradigm for model fitting with applications to image analysis and automated cartography", authors="M.A. Fischler, R.C. Bolles", booktitle="Communications of the ACM, Vol. 24 Issue 6", url="http://dx.doi.org/10.1145/358669.358692")
    public Matrix processIds(DBIDs dBIDs, Relation<? extends NumberVector> relation) {
        int n = RelationUtil.dimensionality(relation);
        SetDBIDs setDBIDs = DBIDUtil.EMPTYDBIDS;
        double d = ChiSquaredDistribution.quantile(0.85, n);
        Random random = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < this.iterations; ++i) {
            ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample(dBIDs, n + 1, random);
            CovarianceMatrix covarianceMatrix = CovarianceMatrix.make(relation, modifiableDBIDs);
            Vector vector = covarianceMatrix.getMeanVector();
            Matrix matrix = covarianceMatrix.destroyToSampleMatrix().inverse();
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                Vector vector2 = relation.get(dBIDIter).getColumnVector().minusEquals(vector);
                double d2 = vector2.transposeTimesTimes(matrix, vector2);
                if (d2 < d) {
                    hashSetModifiableDBIDs.add(dBIDIter);
                }
                dBIDIter.advance();
            }
            if (hashSetModifiableDBIDs.size() > setDBIDs.size()) {
                setDBIDs = hashSetModifiableDBIDs;
            }
            if (hashSetModifiableDBIDs.size() >= dBIDs.size()) break;
        }
        if (setDBIDs.size() <= n) {
            return CovarianceMatrix.make(relation, dBIDs).destroyToSampleMatrix();
        }
        return CovarianceMatrix.make(relation, setDBIDs).destroyToSampleMatrix();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID ITER_ID = new OptionID("ransacpca.iterations", "The number of iterations to perform.");
        public static final OptionID SEED_ID = new OptionID("ransacpca.seed", "Random seed (optional).");
        int iterations = 1000;
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(ITER_ID, 1000);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.iterations = intParameter.intValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected RANSACCovarianceMatrixBuilder makeInstance() {
            return new RANSACCovarianceMatrixBuilder(this.iterations, this.rnd);
        }
    }
}

