/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.ProjectionResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import java.util.List;

public class PCAFilteredResult
extends PCAResult
implements ProjectionResult {
    private double[] strongEigenvalues;
    private Matrix strongEigenvectors;
    private double[] weakEigenvalues;
    private Matrix weakEigenvectors;
    private double explainedVariance;
    private Matrix e_hat;
    private Matrix e_czech;
    private Matrix m_hat;
    private Matrix m_czech;
    private Matrix adapatedStrongEigenvectors = null;

    public PCAFilteredResult(SortedEigenPairs sortedEigenPairs, FilteredEigenPairs filteredEigenPairs, double d, double d2) {
        super(sortedEigenPairs);
        int n = sortedEigenPairs.getEigenPair(0).getEigenvector().getDimensionality();
        double d3 = 0.0;
        double d4 = 0.0;
        List<EigenPair> list = filteredEigenPairs.getStrongEigenPairs();
        this.strongEigenvalues = new double[list.size()];
        this.strongEigenvectors = new Matrix(n, list.size());
        int n2 = 0;
        for (EigenPair eigenPair : list) {
            this.strongEigenvalues[n2] = eigenPair.getEigenvalue();
            this.strongEigenvectors.setCol(n2, eigenPair.getEigenvector());
            d3 += this.strongEigenvalues[n2];
            ++n2;
        }
        list = filteredEigenPairs.getWeakEigenPairs();
        this.weakEigenvalues = new double[list.size()];
        this.weakEigenvectors = new Matrix(n, list.size());
        n2 = 0;
        for (EigenPair eigenPair : list) {
            this.weakEigenvalues[n2] = eigenPair.getEigenvalue();
            this.weakEigenvectors.setCol(n2, eigenPair.getEigenvector());
            d4 += this.weakEigenvalues[n2];
            ++n2;
        }
        this.explainedVariance = d3 / (d3 + d4);
        int n3 = this.strongEigenvalues.length;
        this.e_hat = new Matrix(n, n);
        this.e_czech = new Matrix(n, n);
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 < n3) {
                this.e_czech.set(n2, n2, d);
                this.e_hat.set(n2, n2, d2);
                continue;
            }
            this.e_czech.set(n2, n2, d2);
            this.e_hat.set(n2, n2, d);
        }
        Matrix matrix = this.getEigenvectors();
        this.m_hat = matrix.times(this.e_hat).timesTranspose(matrix);
        this.m_czech = matrix.times(this.e_czech).timesTranspose(matrix);
    }

    public final Matrix getStrongEigenvectors() {
        return this.strongEigenvectors;
    }

    public final double[] getStrongEigenvalues() {
        return this.strongEigenvalues;
    }

    public final Matrix getWeakEigenvectors() {
        return this.weakEigenvectors;
    }

    public final double[] getWeakEigenvalues() {
        return this.weakEigenvalues;
    }

    @Override
    public final int getCorrelationDimension() {
        return this.strongEigenvalues.length;
    }

    public double getExplainedVariance() {
        return this.explainedVariance;
    }

    public Matrix selectionMatrixOfWeakEigenvectors() {
        return this.e_hat;
    }

    public Matrix selectionMatrixOfStrongEigenvectors() {
        return this.e_czech;
    }

    @Override
    public Matrix similarityMatrix() {
        return this.m_hat;
    }

    public Matrix dissimilarityMatrix() {
        return this.m_czech;
    }

    public Matrix adapatedStrongEigenvectors() {
        if (this.adapatedStrongEigenvectors == null) {
            Matrix matrix = this.getEigenvectors();
            this.adapatedStrongEigenvectors = matrix.times(this.e_czech).times(Matrix.identity(matrix.getRowDimensionality(), this.strongEigenvalues.length));
        }
        return this.adapatedStrongEigenvectors;
    }
}

