/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenvalueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.CovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredRunner;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Iterator;
import java.util.LinkedList;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="A General Framework for Increasing the Robustness of PCA-based Correlation Clustering Algorithms", booktitle="Proceedings of the 20th International Conference on Scientific and Statistical Database Management (SSDBM), Hong Kong, China, 2008", url="http://dx.doi.org/10.1007/978-3-540-69497-7_27")
public class PCAFilteredAutotuningRunner
extends PCAFilteredRunner {
    public PCAFilteredAutotuningRunner(CovarianceMatrixBuilder covarianceMatrixBuilder, EigenPairFilter eigenPairFilter, double d, double d2) {
        super(covarianceMatrixBuilder, eigenPairFilter, d, d2);
    }

    @Override
    public PCAFilteredResult processIds(DBIDs dBIDs, Relation<? extends NumberVector> relation) {
        Centroid centroid = Centroid.make(relation, dBIDs);
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(dBIDs.size());
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d = EuclideanDistanceFunction.STATIC.distance(centroid, relation.get(dBIDIter));
            modifiableDoubleDBIDList.add(d, dBIDIter);
            dBIDIter.advance();
        }
        modifiableDoubleDBIDList.sort();
        return this.processQueryResult((DoubleDBIDList)modifiableDoubleDBIDList, (Relation)relation);
    }

    @Override
    public PCAFilteredResult processQueryResult(DoubleDBIDList doubleDBIDList, Relation<? extends NumberVector> relation) {
        Matrix matrix;
        int n;
        this.assertSortedByDistance(doubleDBIDList);
        int n2 = RelationUtil.dimensionality(relation);
        LinkedList<Matrix> linkedList = new LinkedList<Matrix>();
        for (int i = 0; i < n2; ++i) {
            linkedList.add(null);
        }
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = -1.0;
        }
        int[] nArray = new int[n2];
        LinkedList<Cand> linkedList2 = new LinkedList<Cand>();
        int n3 = 3;
        int n4 = 4;
        if (n4 > doubleDBIDList.size() - 1) {
            n4 = doubleDBIDList.size() - 1;
        }
        for (n = n4; n < doubleDBIDList.size(); ++n) {
            matrix = this.covarianceMatrixBuilder.processQueryResults(doubleDBIDList, relation);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
            SortedEigenPairs sortedEigenPairs = new SortedEigenPairs(eigenvalueDecomposition, false);
            FilteredEigenPairs filteredEigenPairs = this.getEigenPairFilter().filter(sortedEigenPairs);
            int n5 = filteredEigenPairs.countStrongEigenPairs();
            assert (n5 > 0 && n5 <= n2);
            double d = this.computeExplainedVariance(filteredEigenPairs);
            linkedList2.add(new Cand(matrix, d, n5));
            if (linkedList2.size() < 2 * n3 + 1) continue;
            boolean bl = true;
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                if (((Cand)iterator.next()).dim == n5) continue;
                bl = false;
            }
            if (bl) {
                double d2 = 0.0;
                Iterator iterator2 = linkedList2.iterator();
                while (iterator2.hasNext()) {
                    d2 += ((Cand)iterator2.next()).explain;
                }
                if ((d2 /= (double)linkedList2.size()) > dArray[n5 - 1]) {
                    dArray[n5 - 1] = d2;
                    linkedList.set(n5 - 1, ((Cand)linkedList2.get((int)n3)).m);
                    nArray[n5 - 1] = n - n3;
                }
            }
            linkedList2.removeFirst();
        }
        for (n = 0; n < n2; ++n) {
            if (!(dArray[n] > 0.0) || nArray[n] == n4 + n3 || nArray[n] == doubleDBIDList.size() - n3 - 1) continue;
            matrix = (Matrix)linkedList.get(n);
            return this.processCovarMatrix(matrix);
        }
        return this.processCovarMatrix(this.covarianceMatrixBuilder.processQueryResults(doubleDBIDList, relation));
    }

    private double computeExplainedVariance(FilteredEigenPairs filteredEigenPairs) {
        double d = 0.0;
        double d2 = 0.0;
        for (EigenPair eigenPair : filteredEigenPairs.getStrongEigenPairs()) {
            d += eigenPair.getEigenvalue();
        }
        for (EigenPair eigenPair : filteredEigenPairs.getWeakEigenPairs()) {
            d2 += eigenPair.getEigenvalue();
        }
        return d / (d / d2);
    }

    private void assertSortedByDistance(DoubleDBIDList doubleDBIDList) {
        double d = -1.0;
        boolean bl = true;
        DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
        while (doubleDBIDListIter.valid()) {
            double d2 = doubleDBIDListIter.doubleValue();
            if (d2 < d) {
                bl = false;
            }
            d = d2;
            doubleDBIDListIter.advance();
        }
        if (!bl) {
            try {
                ((ModifiableDoubleDBIDList)ModifiableDoubleDBIDList.class.cast(doubleDBIDList)).sort();
            }
            catch (ClassCastException classCastException) {
                LoggingUtil.warning("WARNING: results not sorted by distance!", classCastException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LoggingUtil.warning("WARNING: results not sorted by distance!", unsupportedOperationException);
            }
        }
    }

    public static class Parameterizer
    extends PCAFilteredRunner.Parameterizer {
        @Override
        protected PCAFilteredAutotuningRunner makeInstance() {
            return new PCAFilteredAutotuningRunner(this.covarianceMatrixBuilder, this.eigenPairFilter, this.big, this.small);
        }
    }

    static class Cand {
        Matrix m;
        double explain;
        int dim;

        Cand(Matrix matrix, double d, int n) {
            this.m = matrix;
            this.explain = d;
            this.dim = n;
        }
    }
}

