/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;

@Title(value="First n Eigenpair filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and marks the first n eigenpairs as strong eigenpairs.")
public class FirstNEigenPairFilter
implements EigenPairFilter {
    private static final Logging LOG = Logging.getLogger(FirstNEigenPairFilter.class);
    private int n;

    public FirstNEigenPairFilter(int n) {
        this.n = n;
    }

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        StringBuilder stringBuilder = new StringBuilder();
        if (LOG.isDebugging()) {
            stringBuilder.append("sortedEigenPairs ").append(sortedEigenPairs.toString());
            stringBuilder.append("\nn = ").append(this.n);
        }
        ArrayList<EigenPair> arrayList = new ArrayList<EigenPair>();
        ArrayList<EigenPair> arrayList2 = new ArrayList<EigenPair>();
        for (int i = 0; i < sortedEigenPairs.size(); ++i) {
            EigenPair eigenPair = sortedEigenPairs.getEigenPair(i);
            if (i < this.n) {
                arrayList.add(eigenPair);
                continue;
            }
            arrayList2.add(eigenPair);
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\nstrong EigenPairs = ").append(arrayList);
            stringBuilder.append("\nweak EigenPairs = ").append(arrayList2);
            LOG.debugFine(stringBuilder.toString());
        }
        return new FilteredEigenPairs(arrayList2, arrayList);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_N = new OptionID("pca.filter.n", "The number of strong eigenvectors: n eigenvectors with the n highesteigenvalues are marked as strong eigenvectors.");
        protected int n = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(EIGENPAIR_FILTER_N);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.n = intParameter.intValue();
            }
        }

        @Override
        protected FirstNEigenPairFilter makeInstance() {
            return new FirstNEigenPairFilter(this.n);
        }
    }
}

