/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import java.util.List;

public class CompositeEigenPairFilter
implements EigenPairFilter {
    private List<EigenPairFilter> filters;

    public CompositeEigenPairFilter(List<EigenPairFilter> list) {
        this.filters = list;
    }

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        FilteredEigenPairs filteredEigenPairs = null;
        for (EigenPairFilter eigenPairFilter : this.filters) {
            filteredEigenPairs = eigenPairFilter.filter(sortedEigenPairs);
            sortedEigenPairs = new SortedEigenPairs(filteredEigenPairs.getStrongEigenPairs());
        }
        return filteredEigenPairs;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_COMPOSITE_LIST = new OptionID("pca.filter.composite.list", "A comma separated list of the class names of the filters to be used. The specified filters will be applied sequentially in the given order.");
        private List<EigenPairFilter> filters = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(EIGENPAIR_FILTER_COMPOSITE_LIST, EigenPairFilter.class);
            if (parameterization.grab(objectListParameter)) {
                this.filters = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected CompositeEigenPairFilter makeInstance() {
            return new CompositeEigenPairFilter(this.filters);
        }
    }
}

