/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.fitting;

import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.FittingFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.FittingFunctionResult;

public class LevenbergMarquardtMethod {
    public FittingFunction func;
    private double[] x;
    private double[] y;
    private double[] s;
    private int numparams;
    private double[] params;
    private double chisq;
    private int numfit;
    private boolean[] dofit;
    private double[][] covmat;
    private double[][] alpha;
    private double lambda;
    private double[] paramstry;
    private double[] beta;
    private double[] deltaparams;
    public int maxruns = 1000;
    public int maxsmall = 3;
    public double small = 0.01;

    public LevenbergMarquardtMethod(FittingFunction fittingFunction, double[] dArray, boolean[] blArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        assert (dArray2.length == dArray3.length);
        assert (dArray2.length == dArray4.length);
        assert (dArray.length == blArray.length);
        this.func = fittingFunction;
        this.x = dArray2;
        this.y = dArray3;
        this.s = dArray4;
        this.params = dArray;
        this.dofit = blArray;
        this.numparams = this.params.length;
        this.numfit = 0;
        for (int i = 0; i < this.numparams; ++i) {
            if (!blArray[i]) continue;
            ++this.numfit;
        }
        assert (this.numfit > 0);
        this.covmat = new double[this.numfit][this.numfit];
        this.alpha = new double[this.numfit][this.numfit];
        this.lambda = 0.001;
        this.paramstry = (double[])dArray.clone();
        this.beta = new double[this.numfit];
        this.deltaparams = new double[this.numparams];
        this.chisq = this.simulateParameters(dArray);
    }

    private double simulateParameters(double[] dArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.numfit; ++n2) {
            for (int i = 0; i < this.numfit; ++i) {
                this.alpha[n2][i] = 0.0;
            }
        }
        for (n2 = 0; n2 < this.numfit; ++n2) {
            this.beta[n2] = 0.0;
        }
        double d = 0.0;
        for (n = 0; n < this.x.length; ++n) {
            FittingFunctionResult fittingFunctionResult = this.func.eval(this.x[n], dArray);
            double d2 = 1.0 / (this.s[n] * this.s[n]);
            double d3 = this.y[n] - fittingFunctionResult.y;
            int n3 = 0;
            for (int i = 0; i < this.numfit; ++i) {
                if (!this.dofit[i]) continue;
                double d4 = fittingFunctionResult.gradients[i] * d2;
                int n4 = 0;
                for (int j = 0; j <= i; ++j) {
                    if (!this.dofit[j]) continue;
                    double[] dArray2 = this.alpha[n3];
                    int n5 = n4++;
                    dArray2[n5] = dArray2[n5] + d4 * fittingFunctionResult.gradients[j];
                }
                this.beta[n3] = this.beta[n3] + d3 * d4;
                ++n3;
            }
            d += d3 * d3 * d2;
        }
        for (n = 1; n < this.numfit; ++n) {
            for (int i = n + 1; i < this.numfit; ++i) {
                this.alpha[n][i] = this.alpha[i][n];
            }
        }
        return d;
    }

    public void iterate() {
        int n = 0;
        while (n < this.numfit) {
            System.arraycopy(this.alpha[n], 0, this.covmat[n], 0, this.numfit);
            double[] dArray = this.covmat[n];
            int n2 = n++;
            dArray[n2] = dArray[n2] * (1.0 + this.lambda);
        }
        LinearEquationSystem linearEquationSystem = new LinearEquationSystem(this.covmat, this.beta);
        linearEquationSystem.solveByTotalPivotSearch();
        this.covmat = linearEquationSystem.getCoefficents();
        this.deltaparams = linearEquationSystem.getRHS();
        int n3 = 0;
        for (int i = 0; i < this.numparams; ++i) {
            if (!this.dofit[i]) continue;
            this.paramstry[i] = this.params[i] + this.deltaparams[n3];
            ++n3;
        }
        double d = this.simulateParameters(this.paramstry);
        if (d < this.chisq) {
            if (this.lambda * 0.1 > Double.MIN_NORMAL) {
                this.lambda *= 0.1;
            }
            this.chisq = d;
            for (int i = 0; i < this.numfit; ++i) {
                System.arraycopy(this.covmat[i], 0, this.alpha[i], 0, this.numfit);
                this.beta[i] = this.deltaparams[i];
            }
            System.arraycopy(this.paramstry, 0, this.params, 0, this.numparams);
        } else if (this.lambda * 10.0 < Double.MAX_VALUE) {
            this.lambda *= 10.0;
        }
    }

    public double[][] getCovmat() {
        double[][] dArray = new double[this.numparams][this.numparams];
        int n = 0;
        for (int i = 0; i < this.numparams; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.numparams; ++j) {
                dArray[i][j] = this.dofit[i] && this.dofit[j] ? this.covmat[n][n2] : 0.0;
                if (!this.dofit[j]) continue;
                ++n2;
            }
            if (!this.dofit[i]) continue;
            ++n;
        }
        return dArray;
    }

    public double[] getParams() {
        return this.params;
    }

    public double getChiSq() {
        return this.chisq;
    }

    public void run() {
        int n = this.maxsmall;
        for (int i = this.maxruns; i > 0; --i) {
            double d = this.getChiSq();
            this.iterate();
            double d2 = this.getChiSq();
            double d3 = d2 - d;
            if (!(d3 < 0.0) || !(d3 > -this.small) || --n >= 0) continue;
            break;
        }
    }
}

