/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Vector
implements NumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<Vector> BYTE_SERIALIZER = new SmallSerializer();
    public static final ByteBufferSerializer<Vector> SHORT_SERIALIZER = new ShortSerializer();
    public static final ByteBufferSerializer<Vector> VARIABLE_SERIALIZER = new VariableSerializer();
    protected final double[] elements;
    public static final String ERR_VEC_DIMENSIONS = "Vector dimensions do not agree.";
    public static final String ERR_MATRIX_INNERDIM = "Matrix inner dimensions do not agree.";
    private static final String ERR_DIMENSIONS = "Dimensionalities do not agree.";

    public Vector(double ... dArray) {
        this.elements = dArray;
    }

    public Vector(int n) {
        this.elements = new double[n];
    }

    public static final Vector randomNormalizedVector(int n) {
        int n2;
        Vector vector = new Vector(n);
        double d = 0.0;
        while (d <= 0.0) {
            for (n2 = 0; n2 < n; ++n2) {
                vector.elements[n2] = Math.random();
            }
            d = vector.euclideanLength();
        }
        n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            vector.elements[n3] = vector.elements[n3] / d;
        }
        return vector;
    }

    public static final Vector unitVector(int n, int n2) {
        Vector vector = new Vector(n);
        vector.elements[n2] = 1.0;
        return vector;
    }

    public final Vector copy() {
        return new Vector((double[])this.elements.clone());
    }

    public Vector clone() {
        return this.copy();
    }

    public final double[] getArrayRef() {
        return this.elements;
    }

    public final double[] getArrayCopy() {
        return (double[])this.elements.clone();
    }

    @Override
    public final int getDimensionality() {
        return this.elements.length;
    }

    public final double get(int n) {
        return this.elements[n];
    }

    public final Vector set(int n, double d) {
        this.elements[n] = d;
        return this;
    }

    public final Vector set(Vector vector) {
        assert (this.elements.length == vector.elements.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = vector.elements[i];
        }
        return this;
    }

    public final Vector plus(Vector vector) {
        assert (this.elements.length == vector.elements.length) : "Vector dimensions do not agree.";
        Vector vector2 = new Vector(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            vector2.elements[i] = this.elements[i] + vector.elements[i];
        }
        return vector2;
    }

    public final Vector plusTimes(Vector vector, double d) {
        assert (this.elements.length == vector.elements.length) : "Vector dimensions do not agree.";
        Vector vector2 = new Vector(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            vector2.elements[i] = this.elements[i] + vector.elements[i] * d;
        }
        return vector2;
    }

    public final Vector plusEquals(Vector vector) {
        assert (this.elements.length == vector.elements.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] + vector.elements[i];
        }
        return this;
    }

    public final Vector plusTimesEquals(Vector vector, double d) {
        assert (this.elements.length == vector.elements.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] + d * vector.elements[i];
        }
        return this;
    }

    public final Vector plusEquals(double d) {
        int n = 0;
        while (n < this.elements.length) {
            int n2 = n++;
            this.elements[n2] = this.elements[n2] + d;
        }
        return this;
    }

    public final Vector minus(Vector vector) {
        Vector vector2 = new Vector(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            vector2.elements[i] = this.elements[i] - vector.elements[i];
        }
        return vector2;
    }

    public final Vector minusTimes(Vector vector, double d) {
        Vector vector2 = new Vector(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            vector2.elements[i] = this.elements[i] - vector.elements[i] * d;
        }
        return vector2;
    }

    public final Vector minusEquals(Vector vector) {
        assert (this.elements.length == vector.elements.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] - vector.elements[i];
        }
        return this;
    }

    public final Vector minusTimesEquals(Vector vector, double d) {
        assert (this.elements.length == vector.elements.length) : "Vector dimensions do not agree.";
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] - d * vector.elements[i];
        }
        return this;
    }

    public final Vector minusEquals(double d) {
        int n = 0;
        while (n < this.elements.length) {
            int n2 = n++;
            this.elements[n2] = this.elements[n2] - d;
        }
        return this;
    }

    public final Vector times(double d) {
        Vector vector = new Vector(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            vector.elements[i] = this.elements[i] * d;
        }
        return vector;
    }

    public final Vector timesEquals(double d) {
        int n = 0;
        while (n < this.elements.length) {
            int n2 = n++;
            this.elements[n2] = this.elements[n2] * d;
        }
        return this;
    }

    public final Matrix times(Matrix matrix) {
        assert (matrix.elements.length == 1) : "Matrix inner dimensions do not agree.";
        Matrix matrix2 = new Matrix(this.elements.length, matrix.columndimension);
        for (int i = 0; i < matrix.columndimension; ++i) {
            for (int j = 0; j < this.elements.length; ++j) {
                matrix2.elements[j][i] = this.elements[j] * matrix.elements[0][i];
            }
        }
        return matrix2;
    }

    public final Matrix transposeTimes(Matrix matrix) {
        assert (matrix.elements.length == this.elements.length) : "Matrix inner dimensions do not agree.";
        Matrix matrix2 = new Matrix(1, matrix.columndimension);
        for (int i = 0; i < matrix.columndimension; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.elements.length; ++j) {
                d += this.elements[j] * matrix.elements[j][i];
            }
            matrix2.elements[0][i] = d;
        }
        return matrix2;
    }

    public final double transposeTimesTimes(Matrix matrix, Vector vector) {
        assert (matrix.elements.length == this.elements.length) : "Matrix inner dimensions do not agree.";
        double d = 0.0;
        for (int i = 0; i < matrix.columndimension; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.elements.length; ++j) {
                d2 += this.elements[j] * matrix.elements[j][i];
            }
            d += d2 * vector.elements[i];
        }
        return d;
    }

    public final double transposeTimes(Vector vector) {
        assert (vector.elements.length == this.elements.length) : "Matrix inner dimensions do not agree.";
        double d = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            d += this.elements[i] * vector.elements[i];
        }
        return d;
    }

    public final Matrix timesTranspose(Matrix matrix) {
        assert (matrix.columndimension == 1) : "Matrix inner dimensions do not agree.";
        Matrix matrix2 = new Matrix(this.elements.length, matrix.elements.length);
        for (int i = 0; i < matrix.elements.length; ++i) {
            for (int j = 0; j < this.elements.length; ++j) {
                matrix2.elements[j][i] = this.elements[j] * matrix.elements[i][0];
            }
        }
        return matrix2;
    }

    public final Matrix timesTranspose(Vector vector) {
        Matrix matrix = new Matrix(this.elements.length, vector.elements.length);
        for (int i = 0; i < vector.elements.length; ++i) {
            for (int j = 0; j < this.elements.length; ++j) {
                matrix.elements[j][i] = this.elements[j] * vector.elements[i];
            }
        }
        return matrix;
    }

    public final double squaredEuclideanLength() {
        double d = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            double d2 = this.elements[i];
            d += d2 * d2;
        }
        return d;
    }

    public final double euclideanLength() {
        double d = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            double d2 = this.elements[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public final Vector normalize() {
        double d = this.euclideanLength();
        if (d != 0.0) {
            int n = 0;
            while (n < this.elements.length) {
                int n2 = n++;
                this.elements[n2] = this.elements[n2] / d;
            }
        }
        return this;
    }

    public final Vector projection(Matrix matrix) {
        assert (this.elements.length == matrix.elements.length) : "Dimensionalities do not agree.";
        Vector vector = new Vector(this.elements.length);
        for (int i = 0; i < matrix.columndimension; ++i) {
            Vector vector2 = matrix.getCol(i);
            vector.plusTimesEquals(vector2, this.transposeTimes(vector2));
        }
        return vector;
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector vector = (Vector)object;
        if (this.elements.length != vector.elements.length) {
            return false;
        }
        return Arrays.equals(this.elements, vector.elements);
    }

    @Override
    public final String toString() {
        return FormatUtil.format(this);
    }

    public final String toStringNoWhitespace() {
        return "[" + FormatUtil.format(this.elements, ",") + "]";
    }

    public void setZero() {
        Arrays.fill(this.elements, 0.0);
    }

    public Vector rotate90Equals() {
        assert (this.elements.length == 2);
        double d = this.elements[0];
        this.elements[0] = this.elements[1];
        this.elements[1] = -d;
        return this;
    }

    public Vector cross3D(Vector vector) {
        assert (this.elements.length == 3 && vector.elements.length == 3);
        Vector vector2 = new Vector(3);
        vector2.elements[0] = this.elements[1] * vector.elements[2] - this.elements[2] * vector.elements[1];
        vector2.elements[1] = this.elements[2] * vector.elements[0] - this.elements[0] * vector.elements[2];
        vector2.elements[2] = this.elements[0] * vector.elements[1] - this.elements[1] * vector.elements[0];
        return vector2;
    }

    @Override
    public double getMin(int n) {
        return this.elements[n];
    }

    @Override
    public double getMax(int n) {
        return this.elements[n];
    }

    @Override
    @Deprecated
    public Double getValue(int n) {
        return this.elements[n];
    }

    @Override
    public double doubleValue(int n) {
        return this.elements[n];
    }

    @Override
    public float floatValue(int n) {
        return (float)this.elements[n];
    }

    @Override
    public int intValue(int n) {
        return (int)this.elements[n];
    }

    @Override
    public long longValue(int n) {
        return (long)this.elements[n];
    }

    @Override
    public short shortValue(int n) {
        return (short)this.elements[n];
    }

    @Override
    public byte byteValue(int n) {
        return (byte)this.elements[n];
    }

    @Override
    public Vector getColumnVector() {
        return this.copy();
    }

    protected static class VariableSerializer
    implements ByteBufferSerializer<Vector> {
        protected VariableSerializer() {
        }

        @Override
        public Vector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            assert (byteBuffer.remaining() >= 8 * n);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = byteBuffer.getDouble();
            }
            return new Vector(dArray);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, Vector vector) throws IOException {
            assert (byteBuffer.remaining() >= 8 * vector.elements.length);
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, vector.elements.length);
            for (int i = 0; i < vector.elements.length; ++i) {
                byteBuffer.putDouble(vector.elements[i]);
            }
        }

        @Override
        public int getByteSize(Vector vector) {
            return ByteArrayUtil.getUnsignedVarintSize(vector.elements.length) + 8 * vector.elements.length;
        }
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<Vector> {
        @Override
        public Vector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.getShort();
            assert (byteBuffer.remaining() >= 8 * n);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = byteBuffer.getDouble();
            }
            return new Vector(dArray);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, Vector vector) throws IOException {
            assert (vector.elements.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (byteBuffer.remaining() >= 8 * vector.elements.length);
            byteBuffer.putShort((short)vector.elements.length);
            for (int i = 0; i < vector.elements.length; ++i) {
                byteBuffer.putDouble(vector.elements[i]);
            }
        }

        @Override
        public int getByteSize(Vector vector) {
            assert (vector.elements.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 8 * vector.getDimensionality();
        }
    }

    public static class SmallSerializer
    implements ByteBufferSerializer<Vector> {
        @Override
        public Vector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.get();
            assert (byteBuffer.remaining() >= 8 * n);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = byteBuffer.getDouble();
            }
            return new Vector(dArray);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, Vector vector) throws IOException {
            assert (vector.elements.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            assert (byteBuffer.remaining() >= 8 * vector.elements.length);
            byteBuffer.put((byte)vector.elements.length);
            for (int i = 0; i < vector.elements.length; ++i) {
                byteBuffer.putDouble(vector.elements[i]);
            }
        }

        @Override
        public int getByteSize(Vector vector) {
            assert (vector.elements.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            return 1 + 8 * vector.getDimensionality();
        }
    }

    private static class Factory
    implements NumberVector.Factory<Vector> {
        private Factory() {
        }

        @Override
        public <A> Vector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            if (arrayAdapter instanceof NumberArrayAdapter) {
                return new Vector(ArrayLikeUtil.toPrimitiveDoubleArray(a, (NumberArrayAdapter)arrayAdapter));
            }
            double[] dArray = new double[arrayAdapter.size(a)];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = arrayAdapter.get(a, i).doubleValue();
            }
            return new Vector(dArray);
        }

        @Override
        public ByteBufferSerializer<Vector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super Vector> getRestrictionClass() {
            return Vector.class;
        }

        @Override
        public Vector newNumberVector(double[] dArray) {
            return new Vector((double[])dArray.clone());
        }

        @Override
        public <A> Vector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            return new Vector(ArrayLikeUtil.toPrimitiveDoubleArray(a, numberArrayAdapter));
        }

        @Override
        public Vector newNumberVector(NumberVector numberVector) {
            return new Vector(ArrayLikeUtil.toPrimitiveDoubleArray(numberVector));
        }
    }
}

