/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import java.io.Serializable;

public class LUDecomposition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix matrix) {
        this(matrix.getArrayCopy(), matrix.getRowDimensionality(), matrix.getColumnDimensionality());
    }

    public LUDecomposition(double[][] dArray, int n, int n2) {
        this.LU = dArray;
        this.m = n;
        this.n = n2;
        this.piv = new int[n];
        for (int i = 0; i < n; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n2; ++i) {
            double d;
            int n3;
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                dArray2[n4] = dArray[n4][i];
            }
            n4 = 0;
            while (n4 < n) {
                double[] dArray3 = dArray[n4];
                n3 = Math.min(n4, i);
                d = 0.0;
                for (int j = 0; j < n3; ++j) {
                    d += dArray3[j] * dArray2[j];
                }
                int n5 = n4++;
                double d2 = dArray2[n5] - d;
                dArray2[n5] = d2;
                dArray3[i] = d2;
            }
            n4 = i;
            for (n3 = i + 1; n3 < n; ++n3) {
                if (!(Math.abs(dArray2[n3]) > Math.abs(dArray2[n4]))) continue;
                n4 = n3;
            }
            if (n4 != i) {
                for (n3 = 0; n3 < n2; ++n3) {
                    d = dArray[n4][n3];
                    dArray[n4][n3] = dArray[i][n3];
                    dArray[i][n3] = d;
                }
                n3 = this.piv[n4];
                this.piv[n4] = this.piv[i];
                this.piv[i] = n3;
                this.pivsign = -this.pivsign;
            }
            if (i >= n || dArray[i][i] == 0.0) continue;
            for (n3 = i + 1; n3 < n; ++n3) {
                double[] dArray4 = dArray[n3];
                int n6 = i;
                dArray4[n6] = dArray4[n6] / dArray[i][i];
            }
        }
    }

    public boolean isNonsingular() {
        for (int i = 0; i < this.n; ++i) {
            if (this.LU[i][i] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArrayRef();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
            }
        }
        return matrix;
    }

    public Matrix getU() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArrayRef();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i <= j ? this.LU[i][j] : 0.0;
            }
        }
        return matrix;
    }

    public int[] getPivot() {
        int[] nArray = new int[this.m];
        System.arraycopy(this.piv, 0, nArray, 0, this.m);
        return nArray;
    }

    public double[] getDoublePivot() {
        double[] dArray = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            dArray[i] = this.piv[i];
        }
        return dArray;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int i = 0; i < this.n; ++i) {
            d *= this.LU[i][i];
        }
        return d;
    }

    public Matrix solve(Matrix matrix) {
        if (matrix.getRowDimensionality() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int n = matrix.getColumnDimensionality();
        Matrix matrix2 = matrix.getMatrix(this.piv, 0, n - 1);
        double[][] dArray = matrix2.getArrayRef();
        this.solveInplace(dArray, n);
        return matrix2;
    }

    public double[][] solve(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (n != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        double[][] dArray2 = new Matrix(dArray).getMatrix(this.piv, 0, n2 - 1).getArrayRef();
        this.solveInplace(dArray2, n2);
        return dArray2;
    }

    private void solveInplace(double[][] dArray, int n) {
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.n; ++n4) {
            for (n3 = n4 + 1; n3 < this.n; ++n3) {
                for (n2 = 0; n2 < n; ++n2) {
                    double[] dArray2 = dArray[n3];
                    int n5 = n2;
                    dArray2[n5] = dArray2[n5] - dArray[n4][n2] * this.LU[n3][n4];
                }
            }
        }
        for (n4 = this.n - 1; n4 >= 0; --n4) {
            n3 = 0;
            while (n3 < n) {
                double[] dArray3 = dArray[n4];
                int n6 = n3++;
                dArray3[n6] = dArray3[n6] / this.LU[n4][n4];
            }
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n; ++n2) {
                    double[] dArray4 = dArray[n3];
                    int n7 = n2;
                    dArray4[n7] = dArray4[n7] - dArray[n4][n2] * this.LU[n3][n4];
                }
            }
        }
    }
}

