/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.dimensionsimilarity;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarity;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarityMatrix;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.Arrays;

@Reference(authors="D. Guo", title="Coordinating computational and visual approaches for interactive feature selection and multivariate clustering", booktitle="Information Visualization, 2(4)", url="http://dx.doi.org/10.1057/palgrave.ivs.9500053")
public class MCEDimensionSimilarity
implements DimensionSimilarity<NumberVector> {
    public static final MCEDimensionSimilarity STATIC = new MCEDimensionSimilarity();
    public static final int TARGET = 35;

    protected MCEDimensionSimilarity() {
    }

    @Override
    public void computeDimensionSimilarites(Relation<? extends NumberVector> relation, DBIDs dBIDs, DimensionSimilarityMatrix dimensionSimilarityMatrix) {
        int n;
        Object object;
        int n2 = dimensionSimilarityMatrix.size();
        double d = MathUtil.log2((double)dBIDs.size() / 35.0);
        int n3 = Math.max(1, (int)Math.floor(d * 0.5));
        int n4 = 1 << n3;
        double d2 = Math.log(n4);
        ArrayList<ArrayList<DBIDs>> arrayList = this.buildPartitions(relation, dBIDs, n3, dimensionSimilarityMatrix);
        int[][] nArray = new int[n2][n4];
        for (int i = 0; i < n2; ++i) {
            ArrayList<DBIDs> arrayList2 = arrayList.get(i);
            object = nArray[i];
            for (n = 0; n < n4; ++n) {
                object[n] = arrayList2.get(n).size();
            }
        }
        int[][] nArray2 = new int[n4][n4];
        for (int i = 0; i < n2; ++i) {
            object = arrayList.get(i);
            for (n = i + 1; n < n2; ++n) {
                ArrayList<DBIDs> arrayList3 = arrayList.get(n);
                this.intersectionMatrix(nArray2, (ArrayList<? extends DBIDs>)object, arrayList3, n4);
                dimensionSimilarityMatrix.set(i, n, 1.0 - this.getMCEntropy(nArray2, nArray[i], nArray[n], dBIDs.size(), n4, d2));
            }
        }
    }

    private ArrayList<ArrayList<DBIDs>> buildPartitions(Relation<? extends NumberVector> relation, DBIDs dBIDs, int n, DimensionSimilarityMatrix dimensionSimilarityMatrix) {
        int n2 = dimensionSimilarityMatrix.size();
        ArrayList<ArrayList<DBIDs>> arrayList = new ArrayList<ArrayList<DBIDs>>(n2);
        VectorUtil.SortDBIDsBySingleDimension sortDBIDsBySingleDimension = new VectorUtil.SortDBIDsBySingleDimension(relation);
        double[] dArray = new double[dBIDs.size()];
        Mean mean = new Mean();
        for (int i = 0; i < n2; ++i) {
            int n3 = dimensionSimilarityMatrix.dim(i);
            ArrayList<DBIDs> arrayList2 = new ArrayList<DBIDs>(1 << n);
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
            sortDBIDsBySingleDimension.setDimension(n3);
            arrayModifiableDBIDs.sort(sortDBIDsBySingleDimension);
            DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
            for (int j = 0; j < dArray.length; ++j) {
                assert (dBIDArrayMIter.valid());
                dArray[j] = relation.get(dBIDArrayMIter).doubleValue(n3);
                dBIDArrayMIter.advance();
            }
            this.divide(dBIDArrayMIter, dArray, arrayList2, 0, dArray.length, n, mean);
            assert (arrayList2.size() == 1 << n);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private void divide(DBIDArrayIter dBIDArrayIter, double[] dArray, ArrayList<DBIDs> arrayList, int n, int n2, int n3, Mean mean) {
        int n4 = n2 - n;
        if (n3 == 0) {
            if (n4 > 0) {
                HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(n4);
                dBIDArrayIter.seek(n);
                for (int i = n4; i > 0; --i) {
                    hashSetModifiableDBIDs.add(dBIDArrayIter);
                    dBIDArrayIter.advance();
                }
                arrayList.add(hashSetModifiableDBIDs);
            } else {
                arrayList.add(DBIDUtil.EMPTYDBIDS);
            }
            return;
        }
        if (n4 > 0) {
            mean.reset();
            for (int i = n; i < n2; ++i) {
                mean.put(dArray[i]);
            }
            double d = mean.getMean();
            int n5 = Arrays.binarySearch(dArray, n, n2, d);
            if (n5 >= 0) {
                int n6 = n + n2 >> 1;
                while (Double.compare(dArray[n5], d) == 0) {
                    if (n5 < n6) {
                        ++n5;
                        continue;
                    }
                    if (n5 > n6) {
                        --n5;
                        continue;
                    }
                    break;
                }
            } else {
                n5 = -n5 - 1;
            }
            this.divide(dBIDArrayIter, dArray, arrayList, n, n5, n3 - 1, mean);
            this.divide(dBIDArrayIter, dArray, arrayList, n5, n2, n3 - 1, mean);
        } else {
            this.divide(dBIDArrayIter, dArray, arrayList, n, n2, n3 - 1, mean);
            this.divide(dBIDArrayIter, dArray, arrayList, n, n2, n3 - 1, mean);
        }
    }

    private void intersectionMatrix(int[][] nArray, ArrayList<? extends DBIDs> arrayList, ArrayList<? extends DBIDs> arrayList2, int n) {
        for (int i = 0; i < n; ++i) {
            DBIDs dBIDs = arrayList.get(i);
            int[] nArray2 = nArray[i];
            for (int j = 0; j < n; ++j) {
                nArray2[j] = DBIDUtil.intersectionSize(dBIDs, arrayList2.get(j));
            }
        }
    }

    private double getMCEntropy(int[][] nArray, int[] nArray2, int[] nArray3, int n, int n2, double d) {
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d2 = nArray2[i];
            double d3 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                double d4 = (double)nArray[i][j] / d2;
                double d5 = (double)nArray[j][i] / d3;
                if (d4 > 0.0) {
                    int n3 = i;
                    dArray[n3] = dArray[n3] - d4 * Math.log(d4);
                }
                if (!(d5 > 0.0)) continue;
                int n4 = i;
                dArray2[n4] = dArray2[n4] - d5 * Math.log(d5);
            }
        }
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d6 += dArray[i] * (double)nArray2[i];
            d7 += dArray2[i] * (double)nArray3[i];
        }
        double d8 = d6 > d7 ? d6 : d7;
        return d8 / ((double)n * d);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MCEDimensionSimilarity makeInstance() {
            return STATIC;
        }
    }
}

