/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

public class PearsonCorrelation {
    private double sumXX = 0.0;
    private double sumYY = 0.0;
    private double sumXY = 0.0;
    private double meanX = 0.0;
    private double meanY = 0.0;
    private double sumWe = 0.0;

    public void put(double d, double d2, double d3) {
        if (this.sumWe <= 0.0) {
            this.meanX = d;
            this.meanY = d2;
            this.sumWe = d3;
            return;
        }
        this.sumWe += d3;
        double d4 = d - this.meanX;
        double d5 = d2 - this.meanY;
        this.meanX += d4 * d3 / this.sumWe;
        this.meanY += d5 * d3 / this.sumWe;
        double d6 = d - this.meanX;
        double d7 = d2 - this.meanY;
        this.sumXX += d3 * d4 * d6;
        this.sumYY += d3 * d5 * d7;
        this.sumXY += d3 * d4 * d7;
    }

    public void put(double d, double d2) {
        this.put(d, d2, 1.0);
    }

    public double getCorrelation() {
        if (!(this.sumXX > 0.0) || !(this.sumYY > 0.0)) {
            return this.sumXX == this.sumYY ? 1.0 : 0.0;
        }
        return this.sumXY / Math.sqrt(this.sumXX * this.sumYY);
    }

    public double getCount() {
        return this.sumWe;
    }

    public double getMeanX() {
        return this.meanX;
    }

    public double getMeanY() {
        return this.meanY;
    }

    public double getNaiveCovariance() {
        return this.sumXY / this.sumWe;
    }

    public double getSampleCovariance() {
        assert (this.sumWe > 1.0);
        return this.sumXY / (this.sumWe - 1.0);
    }

    public double getNaiveVarianceX() {
        return this.sumXX / this.sumWe;
    }

    public double getSampleVarianceX() {
        assert (this.sumWe > 1.0);
        return this.sumXX / (this.sumWe - 1.0);
    }

    public double getNaiveStddevX() {
        return Math.sqrt(this.getNaiveVarianceX());
    }

    public double getSampleStddevX() {
        return Math.sqrt(this.getSampleVarianceX());
    }

    public double getNaiveVarianceY() {
        return this.sumYY / this.sumWe;
    }

    public double getSampleVarianceY() {
        assert (this.sumWe > 1.0);
        return this.sumYY / (this.sumWe - 1.0);
    }

    public double getNaiveStddevY() {
        return Math.sqrt(this.getNaiveVarianceY());
    }

    public double getSampleStddevY() {
        return Math.sqrt(this.getSampleVarianceY());
    }

    public void reset() {
        this.sumXX = 0.0;
        this.sumXY = 0.0;
        this.sumYY = 0.0;
        this.meanX = 0.0;
        this.meanY = 0.0;
        this.sumWe = 0.0;
    }
}

