/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging.progress;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;

public class MutableProgress
extends AbstractProgress {
    private int total;

    public MutableProgress(String string, int n, Logging logging) {
        super(string);
        this.total = n;
        logging.progress(this);
    }

    @Override
    public StringBuilder appendToBuffer(StringBuilder stringBuilder) {
        int n = (int)((double)this.getProcessed() * 100.0 / (double)this.total);
        stringBuilder.append(this.getTask());
        stringBuilder.append(": ");
        stringBuilder.append(this.getProcessed());
        stringBuilder.append("/");
        stringBuilder.append(this.total);
        stringBuilder.append(" [");
        if (n < 100) {
            stringBuilder.append(' ');
        }
        if (n < 10) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(n);
        stringBuilder.append("%]");
        return stringBuilder;
    }

    @Override
    public boolean isComplete() {
        return this.getProcessed() == this.total;
    }

    public void setTotal(int n) throws IllegalArgumentException {
        if (this.getProcessed() > n) {
            throw new IllegalArgumentException(this.getProcessed() + " exceeds total: " + n);
        }
        this.total = n;
    }

    public int getTotal() {
        return this.total;
    }
}

