/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.ELKILogRecord;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.Progress;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressLogRecord;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.MillisTimeDuration;
import de.lmu.ifi.dbs.elki.logging.statistics.Statistic;
import de.lmu.ifi.dbs.elki.logging.statistics.UnsynchronizedLongCounter;
import java.util.HashMap;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Logging {
    private static HashMap<String, Logging> loggers;
    private final Logger logger;

    public Logging(Logger logger) {
        this.logger = logger;
    }

    public static Logging getLogger(Class<?> clazz) {
        return Logging.getLogger(clazz.getName());
    }

    public static synchronized Logging getLogger(String string) {
        Logging logging = loggers.get(string);
        if (logging == null) {
            logging = new Logging(Logger.getLogger(string));
            loggers.put(string, logging);
        }
        return logging;
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public boolean isStatistics() {
        return this.logger.isLoggable(Level.STATISTICS);
    }

    public boolean isVerbose() {
        return this.logger.isLoggable(Level.VERBOSE);
    }

    public boolean isInfo() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isVeryVerbose() {
        return this.logger.isLoggable(Level.VERYVERBOSE);
    }

    public boolean isDebugging() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isDebuggingFine() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isDebuggingFiner() {
        return this.logger.isLoggable(Level.FINER);
    }

    public boolean isDebuggingFinest() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public void log(java.util.logging.Level level, CharSequence charSequence) {
        ELKILogRecord eLKILogRecord = new ELKILogRecord(level, charSequence);
        this.logger.log(eLKILogRecord);
    }

    public void log(java.util.logging.Level level, CharSequence charSequence, Throwable throwable) {
        ELKILogRecord eLKILogRecord = new ELKILogRecord(level, charSequence);
        eLKILogRecord.setThrown(throwable);
        this.logger.log(eLKILogRecord);
    }

    public void log(LogRecord logRecord) {
        this.logger.log(logRecord);
    }

    public void error(CharSequence charSequence, Throwable throwable) {
        this.log(Level.SEVERE, charSequence, throwable);
    }

    public void error(CharSequence charSequence) {
        this.log(Level.SEVERE, charSequence);
    }

    public void warning(CharSequence charSequence, Throwable throwable) {
        this.log(Level.WARNING, charSequence, throwable);
    }

    public void warning(CharSequence charSequence) {
        this.log(Level.WARNING, charSequence);
    }

    public void statistics(CharSequence charSequence, Throwable throwable) {
        this.log(Level.STATISTICS, charSequence, throwable);
    }

    public void statistics(CharSequence charSequence) {
        this.log(Level.STATISTICS, charSequence);
    }

    public void verbose(CharSequence charSequence, Throwable throwable) {
        this.log(Level.INFO, charSequence, throwable);
    }

    public void verbose(CharSequence charSequence) {
        this.log(Level.INFO, charSequence);
    }

    public void info(CharSequence charSequence, Throwable throwable) {
        this.log(Level.INFO, charSequence, throwable);
    }

    public void info(CharSequence charSequence) {
        this.log(Level.INFO, charSequence);
    }

    public void veryverbose(CharSequence charSequence, Throwable throwable) {
        this.log(Level.VERYVERBOSE, charSequence, throwable);
    }

    public void veryverbose(CharSequence charSequence) {
        this.log(Level.VERYVERBOSE, charSequence);
    }

    public void debug(CharSequence charSequence, Throwable throwable) {
        this.log(Level.FINE, charSequence, throwable);
    }

    public void debug(CharSequence charSequence) {
        this.log(Level.FINE, charSequence);
    }

    public void debugFine(CharSequence charSequence, Throwable throwable) {
        this.log(Level.FINE, charSequence, throwable);
    }

    public void debugFine(CharSequence charSequence) {
        this.log(Level.FINE, charSequence);
    }

    public void fine(CharSequence charSequence, Throwable throwable) {
        this.log(Level.FINE, charSequence, throwable);
    }

    public void fine(CharSequence charSequence) {
        this.log(Level.FINE, charSequence);
    }

    public void debugFiner(CharSequence charSequence, Throwable throwable) {
        this.log(Level.FINER, charSequence, throwable);
    }

    public void debugFiner(CharSequence charSequence) {
        this.log(Level.FINER, charSequence);
    }

    public void finer(CharSequence charSequence, Throwable throwable) {
        this.log(Level.FINER, charSequence, throwable);
    }

    public void finer(CharSequence charSequence) {
        this.log(Level.FINER, charSequence);
    }

    public void debugFinest(CharSequence charSequence, Throwable throwable) {
        this.log(Level.FINEST, charSequence, throwable);
    }

    public void debugFinest(CharSequence charSequence) {
        this.log(Level.FINEST, charSequence);
    }

    public void finest(CharSequence charSequence, Throwable throwable) {
        this.log(Level.FINEST, charSequence, throwable);
    }

    public void finest(CharSequence charSequence) {
        this.log(Level.FINEST, charSequence);
    }

    public void exception(CharSequence charSequence, Throwable throwable) {
        this.log(Level.SEVERE, charSequence, throwable);
    }

    public void exception(Throwable throwable) {
        String string = throwable.getMessage();
        this.log(Level.SEVERE, string != null ? string : "An exception occurred.", throwable);
    }

    public void progress(Progress progress) {
        this.logger.log(new ProgressLogRecord(Level.INFO, progress));
    }

    public Counter newCounter(String string) {
        return new UnsynchronizedLongCounter(string);
    }

    public Duration newDuration(String string) {
        return new MillisTimeDuration(string);
    }

    public void incrementProcessed(AbstractProgress abstractProgress) {
        if (abstractProgress != null) {
            abstractProgress.incrementProcessed(this);
        }
    }

    public void ensureCompleted(FiniteProgress finiteProgress) {
        if (finiteProgress != null) {
            finiteProgress.ensureCompleted(this);
        }
    }

    public void beginStep(StepProgress stepProgress, int n, String string) {
        if (stepProgress != null) {
            stepProgress.beginStep(n, string, this);
        }
    }

    public void setCompleted(StepProgress stepProgress) {
        if (stepProgress != null) {
            stepProgress.setCompleted(this);
        }
    }

    public void setCompleted(IndefiniteProgress indefiniteProgress) {
        if (indefiniteProgress != null) {
            indefiniteProgress.setCompleted(this);
        }
    }

    public void statistics(Statistic statistic) {
        this.log(Level.STATISTICS, statistic.getKey() + ": " + statistic.formatValue());
    }

    public String toString() {
        return "Logging(" + this.logger.getName() + ", " + this.logger.getLevel() + ")";
    }

    static {
        LoggingConfiguration.assertConfigured();
        loggers = new HashMap();
    }

    public static class Level
    extends java.util.logging.Level {
        public static final Level STATISTICS = new Level("STATISTICS", INFO.intValue() + WARNING.intValue() >> 1);
        public static final java.util.logging.Level VERBOSE = INFO;
        public static final Level VERYVERBOSE = new Level("VERYVERBOSE", INFO.intValue() + CONFIG.intValue() >> 1);
        private static final long serialVersionUID = 1L;

        public Level(String string, int n) {
            super(string, n);
        }

        public static java.util.logging.Level parse(String string) {
            return java.util.logging.Level.parse(string);
        }
    }
}

