/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.ErrorFormatter;
import de.lmu.ifi.dbs.elki.logging.MessageFormatter;
import de.lmu.ifi.dbs.elki.logging.OutputStreamLogger;
import de.lmu.ifi.dbs.elki.logging.progress.Progress;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressLogRecord;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressTracker;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CLISmartHandler
extends Handler {
    private Writer out;
    private Writer err;
    private Formatter msgformat = new MessageFormatter();
    private Formatter debugformat = new ErrorFormatter();
    private Formatter errformat = new ErrorFormatter();
    private ProgressTracker ptrack = new ProgressTracker();

    public CLISmartHandler(OutputStream outputStream, OutputStream outputStream2) {
        this.out = new OutputStreamLogger(outputStream);
        this.err = new OutputStreamLogger(outputStream2);
    }

    public CLISmartHandler() {
        this(System.out, System.err);
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
        try {
            this.err.flush();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        String string;
        Object object;
        Writer writer = logRecord.getLevel().intValue() >= Level.WARNING.intValue() ? this.err : this.out;
        if (logRecord instanceof ProgressLogRecord) {
            object = (ProgressLogRecord)logRecord;
            this.ptrack.addProgress(((ProgressLogRecord)object).getProgress());
            Collection<Progress> collection = this.ptrack.removeCompleted();
            Collection<Progress> collection2 = this.ptrack.getProgresses();
            StringBuilder stringBuilder = new StringBuilder();
            if (collection.size() > 0) {
                stringBuilder.append('\r');
                for (Progress object2 : collection) {
                    object2.appendToBuffer(stringBuilder);
                    stringBuilder.append(OutputStreamLogger.NEWLINE);
                }
            }
            if (collection2.size() > 0) {
                boolean bl = true;
                stringBuilder.append('\r');
                for (Progress progress : collection2) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(' ');
                    }
                    progress.appendToBuffer(stringBuilder);
                }
            }
            string = stringBuilder.toString();
        } else {
            object = logRecord.getLevel().intValue() >= Level.WARNING.intValue() ? this.errformat : (logRecord.getLevel().intValue() <= Level.FINE.intValue() ? this.debugformat : this.msgformat);
            try {
                string = ((Formatter)object).format(logRecord);
            }
            catch (Exception exception) {
                this.reportError(null, exception, 5);
                return;
            }
        }
        try {
            writer.write(string);
            writer.flush();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
            return;
        }
    }
}

