/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.vafile;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.index.vafile.VectorApproximation;

public class VALPNormDistance {
    private final double onebyp;
    private double[][] lookup;
    private VectorApproximation queryApprox;

    public VALPNormDistance(double d, double[][] dArray, NumberVector numberVector, VectorApproximation vectorApproximation) {
        this.onebyp = 1.0 / d;
        this.queryApprox = vectorApproximation;
        this.initializeLookupTable(dArray, numberVector, d);
    }

    public double getPartialMinDist(int n, int n2) {
        int n3 = this.queryApprox.getApproximation(n);
        if (n2 < n3) {
            return this.lookup[n][n2 + 1];
        }
        if (n2 > n3) {
            return this.lookup[n][n2];
        }
        return 0.0;
    }

    public double getMinDist(VectorApproximation vectorApproximation) {
        int n = this.lookup.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = vectorApproximation.getApproximation(i);
            d += this.getPartialMinDist(i, n2);
        }
        return Math.pow(d, this.onebyp);
    }

    public double getPartialMaxDist(int n, int n2) {
        int n3 = this.queryApprox.getApproximation(n);
        if (n2 < n3) {
            return this.lookup[n][n2];
        }
        if (n2 > n3) {
            return this.lookup[n][n2 + 1];
        }
        return Math.max(this.lookup[n][n2], this.lookup[n][n2 + 1]);
    }

    public double getMaxDist(VectorApproximation vectorApproximation) {
        int n = this.lookup.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = vectorApproximation.getApproximation(i);
            d += this.getPartialMaxDist(i, n2);
        }
        return Math.pow(d, this.onebyp);
    }

    public double getPartialMaxMaxDist(int n) {
        double[] dArray = this.lookup[n];
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d = Math.max(d, dArray[i]);
        }
        return d;
    }

    private void initializeLookupTable(double[][] dArray, NumberVector numberVector, double d) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        this.lookup = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i);
            for (int j = 0; j < n2; ++j) {
                this.lookup[i][j] = Math.pow(dArray[i][j] - d2, d);
            }
        }
    }
}

