/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.Arrays;

@Reference(authors="N. Beckmann, H.-P. Kriegel, R. Schneider, B. Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proceedings of the 1990 ACM SIGMOD International Conference on Management of Data, Atlantic City, NJ, May 23-25, 1990", url="http://dx.doi.org/10.1145/93597.98741")
@Alias(value={"de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.util.TopologicalSplitter"})
public class TopologicalSplitter
implements SplitStrategy {
    public static final TopologicalSplitter STATIC = new TopologicalSplitter();

    @Override
    public <E extends SpatialComparable, A> long[] split(A a, ArrayAdapter<E, A> arrayAdapter, int n) {
        Split<A, E> split = new Split<A, E>(a, arrayAdapter);
        split.chooseSplitAxis(n);
        split.chooseSplitPoint(n);
        assert (split.splitPoint < ((Split)split).size) : "Invalid split produced. Size: " + arrayAdapter.size(a) + " minEntries: " + n + " split.size: " + Split.access$000(split);
        long[] lArray = BitsUtil.zero(((Split)split).size);
        for (int i = split.splitPoint; i < ((Split)split).size; ++i) {
            BitsUtil.setI(lArray, split.bestSorting[i].second);
        }
        return lArray;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected TopologicalSplitter makeInstance() {
            return STATIC;
        }
    }

    private class Split<A, E extends SpatialComparable> {
        int splitPoint = -1;
        DoubleIntPair[] bestSorting;
        DoubleIntPair[] maxSorting;
        DoubleIntPair[] minSorting;
        private A entries;
        private ArrayAdapter<E, A> getter;
        private int size;
        private int dimensionality;

        public Split(A a, ArrayAdapter<E, A> arrayAdapter) {
            this.entries = a;
            this.getter = arrayAdapter;
            this.size = arrayAdapter.size(a);
            this.dimensionality = ((SpatialComparable)arrayAdapter.get(a, 0)).getDimensionality();
            this.initMinMaxArrays();
        }

        void chooseSplitAxis(int n) {
            double d = Double.MAX_VALUE;
            int n2 = -1;
            for (int i = 0; i < this.dimensionality; ++i) {
                double d2 = 0.0;
                this.fillAndSort(i);
                ModifiableHyperBoundingBox modifiableHyperBoundingBox = new ModifiableHyperBoundingBox((SpatialComparable)this.get(this.minSorting[0]));
                ModifiableHyperBoundingBox modifiableHyperBoundingBox2 = new ModifiableHyperBoundingBox((SpatialComparable)this.get(this.minSorting[this.size - 1]));
                ModifiableHyperBoundingBox modifiableHyperBoundingBox3 = new ModifiableHyperBoundingBox((SpatialComparable)this.get(this.maxSorting[0]));
                ModifiableHyperBoundingBox modifiableHyperBoundingBox4 = new ModifiableHyperBoundingBox((SpatialComparable)this.get(this.maxSorting[this.size - 1]));
                for (int j = 1; j < this.size - n; ++j) {
                    modifiableHyperBoundingBox.extend((SpatialComparable)this.get(this.minSorting[j]));
                    modifiableHyperBoundingBox2.extend((SpatialComparable)this.get(this.minSorting[this.size - 1 - j]));
                    modifiableHyperBoundingBox3.extend((SpatialComparable)this.get(this.maxSorting[j]));
                    modifiableHyperBoundingBox4.extend((SpatialComparable)this.get(this.maxSorting[this.size - 1 - j]));
                    if (j < n - 1) continue;
                    d2 += SpatialUtil.perimeter(modifiableHyperBoundingBox) + SpatialUtil.perimeter(modifiableHyperBoundingBox2) + SpatialUtil.perimeter(modifiableHyperBoundingBox3) + SpatialUtil.perimeter(modifiableHyperBoundingBox4);
                }
                if (!(d2 < d)) continue;
                n2 = i;
                d = d2;
            }
            if (n2 != this.dimensionality) {
                this.fillAndSort(n2);
            }
        }

        protected void initMinMaxArrays() {
            this.maxSorting = new DoubleIntPair[this.size];
            this.minSorting = new DoubleIntPair[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.minSorting[i] = new DoubleIntPair(0.0, -1);
                this.maxSorting[i] = new DoubleIntPair(0.0, -1);
            }
        }

        protected void fillAndSort(int n) {
            for (int i = 0; i < this.size; ++i) {
                E e = this.get(i);
                this.minSorting[i].first = e.getMin(n);
                this.minSorting[i].second = i;
                this.maxSorting[i].first = e.getMax(n);
                this.maxSorting[i].second = i;
            }
            Arrays.sort(this.minSorting);
            Arrays.sort(this.maxSorting);
        }

        void chooseSplitPoint(int n) {
            double d;
            double d2;
            ModifiableHyperBoundingBox modifiableHyperBoundingBox;
            int n2;
            this.splitPoint = this.size;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            this.bestSorting = null;
            assert (this.size - 2 * n >= 0) : "Cannot split nodes (" + this.size + " < 2*" + n + ")";
            ModifiableHyperBoundingBox modifiableHyperBoundingBox2 = this.mbr(this.minSorting, 0, n - 1);
            for (n2 = 0; n2 <= this.size - 2 * n; ++n2) {
                modifiableHyperBoundingBox2.extend((SpatialComparable)this.getter.get(this.entries, this.minSorting[n + n2 - 1].second));
                modifiableHyperBoundingBox = this.mbr(this.minSorting, n + n2, this.size);
                d2 = SpatialUtil.relativeOverlap(modifiableHyperBoundingBox2, modifiableHyperBoundingBox);
                if (!(d2 <= d3)) continue;
                d = SpatialUtil.volume(modifiableHyperBoundingBox2) + SpatialUtil.volume(modifiableHyperBoundingBox);
                if (!(d2 < d3) && !(d < d4)) continue;
                d3 = d2;
                d4 = d;
                this.splitPoint = n + n2;
                this.bestSorting = this.minSorting;
            }
            modifiableHyperBoundingBox2 = this.mbr(this.maxSorting, 0, n - 1);
            for (n2 = 0; n2 <= this.size - 2 * n; ++n2) {
                modifiableHyperBoundingBox2.extend((SpatialComparable)this.getter.get(this.entries, this.maxSorting[n + n2 - 1].second));
                modifiableHyperBoundingBox = this.mbr(this.maxSorting, n + n2, this.size);
                d2 = SpatialUtil.relativeOverlap(modifiableHyperBoundingBox2, modifiableHyperBoundingBox);
                if (!(d2 <= d3)) continue;
                d = SpatialUtil.volume(modifiableHyperBoundingBox2) + SpatialUtil.volume(modifiableHyperBoundingBox);
                if (!(d2 < d3) && !(d < d4)) continue;
                d3 = d2;
                d4 = d;
                this.splitPoint = n + n2;
                this.bestSorting = this.maxSorting;
            }
            assert (this.splitPoint < this.size) : "No split found? Volume outside of double precision?";
        }

        private E get(int n) {
            return (E)((SpatialComparable)this.getter.get(this.entries, n));
        }

        private E get(DoubleIntPair doubleIntPair) {
            return (E)((SpatialComparable)this.getter.get(this.entries, doubleIntPair.second));
        }

        private ModifiableHyperBoundingBox mbr(DoubleIntPair[] doubleIntPairArray, int n, int n2) {
            ModifiableHyperBoundingBox modifiableHyperBoundingBox = new ModifiableHyperBoundingBox((SpatialComparable)this.get(doubleIntPairArray[n]));
            for (int i = n + 1; i < n2; ++i) {
                modifiableHyperBoundingBox.extend((SpatialComparable)this.get(doubleIntPairArray[i]));
            }
            return modifiableHyperBoundingBox;
        }
    }
}

