/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.overflow;

import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.overflow.OverflowTreatment;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert.CloseReinsert;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert.ReinsertStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.util.NodeArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="N. Beckmann, H.-P. Kriegel, R. Schneider, B. Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proceedings of the 1990 ACM SIGMOD International Conference on Management of Data, Atlantic City, NJ, May 23-25, 1990", url="http://dx.doi.org/10.1145/93597.98741")
public class LimitedReinsertOverflowTreatment
implements OverflowTreatment {
    public static final LimitedReinsertOverflowTreatment RSTAR_OVERFLOW = new LimitedReinsertOverflowTreatment(new CloseReinsert(0.3, SquaredEuclideanDistanceFunction.STATIC));
    private long[] reinsertions = new long[1];
    private final ReinsertStrategy reinsertStrategy;

    public LimitedReinsertOverflowTreatment(ReinsertStrategy reinsertStrategy) {
        this.reinsertStrategy = reinsertStrategy;
    }

    @Override
    public <N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry> boolean handleOverflow(AbstractRStarTree<N, E, ?> abstractRStarTree, N n, IndexTreePath<E> indexTreePath) {
        int n2 = indexTreePath.getPathCount() - 1;
        if (n2 == 0) {
            return false;
        }
        if (BitsUtil.capacity(this.reinsertions) < n2) {
            this.reinsertions = BitsUtil.copy(this.reinsertions, n2);
        }
        if (BitsUtil.get(this.reinsertions, n2)) {
            return false;
        }
        BitsUtil.setI(this.reinsertions, n2);
        SpatialEntry spatialEntry = (SpatialEntry)indexTreePath.getEntry();
        assert (!spatialEntry.isLeafEntry()) : "Unexpected leaf entry";
        int[] nArray = this.reinsertStrategy.computeReinserts(n, NodeArrayAdapter.STATIC, spatialEntry);
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        abstractRStarTree.reInsert(n, indexTreePath, nArray);
        return true;
    }

    @Override
    public void reinitialize() {
        BitsUtil.zeroI(this.reinsertions);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static OptionID REINSERT_STRATEGY_ID = new OptionID("rtree.reinsertion-strategy", "The strategy to select candidates for reinsertion.");
        ReinsertStrategy reinsertStrategy = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(REINSERT_STRATEGY_ID, (Class<?>)ReinsertStrategy.class, CloseReinsert.class);
            if (parameterization.grab(objectParameter)) {
                this.reinsertStrategy = (ReinsertStrategy)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected LimitedReinsertOverflowTreatment makeInstance() {
            return new LimitedReinsertOverflowTreatment(this.reinsertStrategy);
        }
    }
}

