/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="N. Beckmann, H.-P. Kriegel, R. Schneider, B. Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proceedings of the 1990 ACM SIGMOD International Conference on Management of Data, Atlantic City, NJ, May 23-25, 1990", url="http://dx.doi.org/10.1145/93597.98741")
public class LeastOverlapInsertionStrategy
implements InsertionStrategy {
    public static final LeastOverlapInsertionStrategy STATIC = new LeastOverlapInsertionStrategy();

    @Override
    public <A> int choose(A a, ArrayAdapter<? extends SpatialComparable, A> arrayAdapter, SpatialComparable spatialComparable, int n, int n2) {
        int n3 = arrayAdapter.size(a);
        assert (n3 > 0) : "Choose from empty set?";
        int n4 = -1;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n3; ++i) {
            double d4;
            double d5;
            SpatialComparable spatialComparable2 = arrayAdapter.get(a, i);
            ModifiableHyperBoundingBox modifiableHyperBoundingBox = SpatialUtil.union(spatialComparable2, spatialComparable);
            double d6 = 0.0;
            double d7 = 0.0;
            for (int j = 0; j < n3; ++j) {
                if (i == j) continue;
                SpatialComparable spatialComparable3 = arrayAdapter.get(a, j);
                d6 += SpatialUtil.relativeOverlap(spatialComparable2, spatialComparable3);
                d7 += SpatialUtil.relativeOverlap(modifiableHyperBoundingBox, spatialComparable3);
            }
            double d8 = d7 - d6;
            if (d8 < d) {
                d5 = SpatialUtil.volume(spatialComparable2);
                d4 = SpatialUtil.volume(modifiableHyperBoundingBox) - d5;
                d = d8;
                d2 = d4;
                d3 = d5;
                n4 = i;
                continue;
            }
            if (d8 != d) continue;
            d5 = SpatialUtil.volume(spatialComparable2);
            d4 = SpatialUtil.volume(modifiableHyperBoundingBox) - d5;
            if (!(d4 < d2) && (d4 != d2 || !(d5 < d3))) continue;
            d = d8;
            d2 = d4;
            d3 = d5;
            n4 = i;
        }
        assert (n4 > -1) : "No split found? Volume outside of double precision?";
        return n4;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LeastOverlapInsertionStrategy makeInstance() {
            return STATIC;
        }
    }
}

