/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Antonin Guttman", title="R-Trees: A Dynamic Index Structure For Spatial Searching", booktitle="Proceedings of the 1984 ACM SIGMOD international conference on Management of data", url="http://dx.doi.org/10.1145/971697.602266")
public class LeastEnlargementInsertionStrategy
implements InsertionStrategy {
    public static final LeastEnlargementInsertionStrategy STATIC = new LeastEnlargementInsertionStrategy();

    @Override
    public <A> int choose(A a, ArrayAdapter<? extends SpatialComparable, A> arrayAdapter, SpatialComparable spatialComparable, int n, int n2) {
        int n3 = arrayAdapter.size(a);
        assert (n3 > 0) : "Choose from empty set?";
        double d = Double.POSITIVE_INFINITY;
        int n4 = -1;
        for (int i = 0; i < n3; ++i) {
            SpatialComparable spatialComparable2 = arrayAdapter.get(a, i);
            double d2 = SpatialUtil.enlargement(spatialComparable2, spatialComparable);
            if (!(d2 < d)) continue;
            d = d2;
            n4 = i;
        }
        assert (n4 > -1);
        return n4;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LeastEnlargementInsertionStrategy makeInstance() {
            return STATIC;
        }
    }
}

