/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar.RStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar.RStarTreeNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;

public class RStarTreeIndex<O extends NumberVector>
extends RStarTree
implements RangeIndex<O>,
KNNIndex<O>,
DynamicIndex {
    private static final Logging LOG = Logging.getLogger(RStarTreeIndex.class);
    private Relation<O> relation;

    public RStarTreeIndex(Relation<O> relation, PageFile<RStarTreeNode> pageFile, AbstractRTreeSettings abstractRTreeSettings) {
        super(pageFile, abstractRTreeSettings);
        this.relation = relation;
    }

    protected SpatialPointLeafEntry createNewLeafEntry(DBIDRef dBIDRef) {
        return new SpatialPointLeafEntry(DBIDUtil.deref(dBIDRef), (NumberVector)this.relation.get(dBIDRef));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public void insert(DBIDRef dBIDRef) {
        this.insertLeaf(this.createNewLeafEntry(dBIDRef));
    }

    @Override
    public void insertAll(DBIDs dBIDs) {
        if (dBIDs.isEmpty() || dBIDs.size() == 1) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<SpatialPointLeafEntry> arrayList = new ArrayList<SpatialPointLeafEntry>(dBIDs.size());
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                arrayList.add(this.createNewLeafEntry(dBIDIter));
                dBIDIter.advance();
            }
            this.bulkLoad(arrayList);
        } else {
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                this.insert(DBIDUtil.deref(dBIDIter));
                dBIDIter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    public boolean delete(DBIDRef dBIDRef) {
        NumberVector numberVector = (NumberVector)this.relation.get(dBIDRef);
        IndexTreePath indexTreePath = this.findPathToObject(this.getRootPath(), numberVector, dBIDRef);
        if (indexTreePath == null) {
            return false;
        }
        this.deletePath(indexTreePath);
        return true;
    }

    @Override
    public void deleteAll(DBIDs dBIDs) {
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            this.delete(dBIDIter);
            dBIDIter.advance();
        }
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery spatialDistanceQuery = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getRangeQuery(this, spatialDistanceQuery, objectArray);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery spatialDistanceQuery = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getKNNQuery(this, spatialDistanceQuery, objectArray);
    }

    @Override
    public String getLongName() {
        return "R*-Tree";
    }

    @Override
    public String getShortName() {
        return "rstartree";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

