/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;

public class DeLiCluTreeIndex<O extends NumberVector>
extends DeLiCluTree
implements KNNIndex<O>,
RangeIndex<O>,
DynamicIndex {
    private Relation<O> relation;
    private static final Logging LOG = Logging.getLogger(DeLiCluTreeIndex.class);

    public DeLiCluTreeIndex(Relation<O> relation, PageFile<DeLiCluNode> pageFile, AbstractRTreeSettings abstractRTreeSettings) {
        super(pageFile, abstractRTreeSettings);
        this.relation = relation;
    }

    protected DeLiCluLeafEntry createNewLeafEntry(DBID dBID) {
        return new DeLiCluLeafEntry(dBID, (NumberVector)this.relation.get(dBID));
    }

    public synchronized IndexTreePath<DeLiCluEntry> setHandled(DBID dBID, O o) {
        IndexTreePath<DeLiCluEntry> indexTreePath;
        if (LOG.isDebugging()) {
            LOG.debugFine("setHandled " + dBID + ", " + o + "\n");
        }
        if ((indexTreePath = this.findPathToObject(this.getRootPath(), (SpatialComparable)o, dBID)) == null) {
            throw new AbortException("Object not found in setHandled.");
        }
        DeLiCluEntry deLiCluEntry = (DeLiCluEntry)indexTreePath.getEntry();
        deLiCluEntry.setHasHandled(true);
        deLiCluEntry.setHasUnhandled(false);
        IndexTreePath<DeLiCluEntry> indexTreePath2 = indexTreePath;
        while (indexTreePath2.getParentPath() != null) {
            DeLiCluEntry deLiCluEntry2 = (DeLiCluEntry)indexTreePath2.getParentPath().getEntry();
            DeLiCluNode deLiCluNode = (DeLiCluNode)this.getNode(deLiCluEntry2);
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < deLiCluNode.getNumEntries(); ++i) {
                DeLiCluEntry deLiCluEntry3 = (DeLiCluEntry)deLiCluNode.getEntry(i);
                bl = bl || deLiCluEntry3.hasHandled();
                bl2 = bl2 || deLiCluEntry3.hasUnhandled();
            }
            deLiCluEntry2.setHasUnhandled(bl2);
            deLiCluEntry2.setHasHandled(bl);
            indexTreePath2 = indexTreePath2.getParentPath();
        }
        return indexTreePath;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public final void insert(DBIDRef dBIDRef) {
        this.insertLeaf(this.createNewLeafEntry(DBIDUtil.deref(dBIDRef)));
    }

    @Override
    public final void insertAll(DBIDs dBIDs) {
        if (dBIDs.isEmpty() || dBIDs.size() == 1) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<DeLiCluLeafEntry> arrayList = new ArrayList<DeLiCluLeafEntry>(dBIDs.size());
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                arrayList.add(this.createNewLeafEntry(DBIDUtil.deref(dBIDIter)));
                dBIDIter.advance();
            }
            this.bulkLoad(arrayList);
        } else {
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                this.insert(dBIDIter);
                dBIDIter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    public final boolean delete(DBIDRef dBIDRef) {
        NumberVector numberVector = (NumberVector)this.relation.get(dBIDRef);
        IndexTreePath indexTreePath = this.findPathToObject(this.getRootPath(), numberVector, dBIDRef);
        if (indexTreePath == null) {
            return false;
        }
        this.deletePath(indexTreePath);
        return true;
    }

    @Override
    public void deleteAll(DBIDs dBIDs) {
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            this.delete(DBIDUtil.deref(dBIDIter));
            dBIDIter.advance();
        }
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery spatialDistanceQuery = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getRangeQuery(this, spatialDistanceQuery, objectArray);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery spatialDistanceQuery = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getKNNQuery(this, spatialDistanceQuery, objectArray);
    }

    @Override
    public String getLongName() {
        return "DeLiClu-Tree";
    }

    @Override
    public String getShortName() {
        return "deliclutree";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

