/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants;

import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.BreadthFirstEnumeration;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.util.NodeArrayAdapter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class AbstractRStarTree<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry, S extends AbstractRTreeSettings>
extends SpatialIndexTree<N, E> {
    protected static final boolean EXTRA_INTEGRITY_CHECKS = false;
    protected int height;
    public Statistics statistics = new Statistics();
    E lastInsertedEntry = null;
    protected S settings;

    public AbstractRStarTree(PageFile<N> pageFile, S s) {
        super(pageFile);
        this.settings = s;
    }

    protected IndexTreePath<E> findPathToObject(IndexTreePath<E> indexTreePath, SpatialComparable spatialComparable, DBIDRef dBIDRef) {
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(indexTreePath.getEntry());
        if (abstractRStarTreeNode.isLeaf()) {
            for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
                if (!DBIDUtil.equal(((LeafEntry)abstractRStarTreeNode.getEntry(i)).getDBID(), dBIDRef)) continue;
                return new IndexTreePath<E>(indexTreePath, abstractRStarTreeNode.getEntry(i), i);
            }
        } else {
            for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
                IndexTreePath<E> indexTreePath2;
                IndexTreePath<E> indexTreePath3;
                if (!SpatialUtil.intersects((SpatialComparable)abstractRStarTreeNode.getEntry(i), spatialComparable) || (indexTreePath3 = this.findPathToObject(indexTreePath2 = new IndexTreePath<E>(indexTreePath, abstractRStarTreeNode.getEntry(i), i), spatialComparable, dBIDRef)) == null) continue;
                return indexTreePath3;
            }
        }
        return null;
    }

    @Override
    public void insertLeaf(E e) {
        if (!this.initialized) {
            this.initialize(e);
        }
        ((AbstractRTreeSettings)this.settings).getOverflowTreatment().reinitialize();
        this.preInsert(e);
        this.insertLeafEntry(e);
        this.doExtraIntegrityChecks();
    }

    protected void insertLeafEntry(E e) {
        this.lastInsertedEntry = e;
        IndexTreePath indexTreePath = this.choosePath(this.getRootPath(), (SpatialComparable)e, this.height, 1);
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("insertion-subtree " + indexTreePath);
        }
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(indexTreePath.getEntry());
        abstractRStarTreeNode.addLeafEntry(e);
        this.writeNode(abstractRStarTreeNode);
        this.adjustTree(indexTreePath);
    }

    protected void insertDirectoryEntry(E e, int n) {
        this.lastInsertedEntry = e;
        IndexTreePath indexTreePath = this.choosePath(this.getRootPath(), (SpatialComparable)e, n, 1);
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("subtree " + indexTreePath);
        }
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(indexTreePath.getEntry());
        abstractRStarTreeNode.addDirectoryEntry(e);
        this.writeNode(abstractRStarTreeNode);
        this.adjustTree(indexTreePath);
    }

    protected void deletePath(IndexTreePath<E> indexTreePath) {
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(indexTreePath.getParentPath().getEntry());
        int n = indexTreePath.getIndex();
        SpatialEntry spatialEntry = (SpatialEntry)abstractRStarTreeNode.getEntry(n);
        abstractRStarTreeNode.deleteEntry(n);
        this.writeNode(abstractRStarTreeNode);
        Stack stack = new Stack();
        this.condenseTree(indexTreePath.getParentPath(), stack);
        while (!stack.empty()) {
            int n2;
            AbstractRStarTreeNode abstractRStarTreeNode2 = (AbstractRStarTreeNode)stack.pop();
            if (abstractRStarTreeNode2.isLeaf()) {
                for (n2 = 0; n2 < abstractRStarTreeNode2.getNumEntries(); ++n2) {
                    ((AbstractRTreeSettings)this.settings).getOverflowTreatment().reinitialize();
                    this.insertLeafEntry((SpatialEntry)abstractRStarTreeNode2.getEntry(n2));
                }
            } else {
                for (n2 = 0; n2 < abstractRStarTreeNode2.getNumEntries(); ++n2) {
                    stack.push(this.getNode(abstractRStarTreeNode2.getEntry(n2)));
                }
            }
            this.deleteNode(abstractRStarTreeNode2);
        }
        this.postDelete(spatialEntry);
        this.doExtraIntegrityChecks();
    }

    @Override
    public void initializeFromFile(TreeIndexHeader treeIndexHeader, PageFile<N> pageFile) {
        super.initializeFromFile(treeIndexHeader, pageFile);
        this.height = this.computeHeight();
        if (this.getLogger().isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass());
            stringBuilder.append("\n height = ").append(this.height);
            this.getLogger().debugFine(stringBuilder.toString());
        }
    }

    @Override
    protected void initializeCapacities(E e) {
        SpatialComparable spatialComparable;
        ObjectOutputStream objectOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        int n;
        try {
            n = 0;
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            spatialComparable = new SpatialPointLeafEntry(DBIDUtil.importInteger(0), new double[e.getDimensionality()]);
            while (byteArrayOutputStream.size() <= this.getPageSize()) {
                spatialComparable.writeExternal(objectOutputStream);
                objectOutputStream.flush();
                ++n;
            }
            this.leafCapacity = n - 1;
        }
        catch (IOException iOException) {
            throw new AbortException("Error determining page sizes.", iOException);
        }
        try {
            n = 0;
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            spatialComparable = new ModifiableHyperBoundingBox(new double[e.getDimensionality()], new double[e.getDimensionality()]);
            SpatialDirectoryEntry spatialDirectoryEntry = new SpatialDirectoryEntry(0, (ModifiableHyperBoundingBox)spatialComparable);
            while (byteArrayOutputStream.size() <= this.getPageSize()) {
                spatialDirectoryEntry.writeExternal(objectOutputStream);
                objectOutputStream.flush();
                ++n;
            }
            this.dirCapacity = n - 1;
        }
        catch (IOException iOException) {
            throw new AbortException("Error determining page sizes.", iOException);
        }
        if (this.dirCapacity <= 2) {
            throw new IllegalArgumentException("Node size of " + this.getPageSize() + " bytes is chosen too small!");
        }
        Logging logging = this.getLogger();
        if (this.dirCapacity < 10) {
            logging.warning("Page size is choosen very small! Maximum number of entries in a directory node = " + this.dirCapacity);
        }
        this.dirMinimum = (int)Math.floor((double)this.dirCapacity * ((AbstractRTreeSettings)this.settings).relativeMinFill);
        if (this.dirMinimum < 1) {
            this.dirMinimum = 1;
        }
        if (this.leafCapacity <= 2) {
            throw new IllegalArgumentException("Node size of " + this.getPageSize() + " bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            logging.warning("Page size is choosen very small! Maximum number of entries in a leaf node = " + this.leafCapacity);
        }
        this.leafMinimum = (int)Math.floor((double)this.leafCapacity * ((AbstractRTreeSettings)this.settings).relativeMinFill);
        if (this.leafMinimum < 1) {
            this.leafMinimum = 1;
        }
    }

    public boolean canBulkLoad() {
        return ((AbstractRTreeSettings)this.settings).bulkSplitter != null && !this.initialized;
    }

    protected List<E> createBulkLeafNodes(List<E> list) {
        int n = this.leafMinimum;
        int n2 = this.leafCapacity;
        ArrayList<E> arrayList = new ArrayList<E>();
        List<List<E>> list2 = ((AbstractRTreeSettings)this.settings).bulkSplitter.partition(list, n, n2);
        for (List<E> list3 : list2) {
            AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.createNewLeafNode();
            for (SpatialEntry spatialEntry : list3) {
                abstractRStarTreeNode.addLeafEntry(spatialEntry);
            }
            this.writeNode(abstractRStarTreeNode);
            arrayList.add(this.createNewDirectoryEntry(abstractRStarTreeNode));
            if (!this.getLogger().isDebugging()) continue;
            this.getLogger().debugFine("Created leaf page " + abstractRStarTreeNode.getPageID());
        }
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("numDataPages = " + arrayList.size());
        }
        return arrayList;
    }

    protected abstract void bulkLoad(List<E> var1);

    public final int getHeight() {
        return this.height;
    }

    protected void setHeight(int n) {
        this.height = n;
    }

    protected abstract int computeHeight();

    protected abstract boolean hasOverflow(N var1);

    protected abstract boolean hasUnderflow(N var1);

    protected abstract E createNewDirectoryEntry(N var1);

    protected IndexTreePath<E> createNewRoot(N n, N n2) {
        Object object;
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.createNewDirectoryNode();
        this.writeNode(abstractRStarTreeNode);
        ((AbstractExternalizablePage)n).setPageID(abstractRStarTreeNode.getPageID());
        if (!((AbstractNode)n).isLeaf()) {
            for (int i = 0; i < ((AbstractNode)n).getNumEntries(); ++i) {
                object = (AbstractRStarTreeNode)this.getNode(((AbstractNode)n).getEntry(i));
                this.writeNode(object);
            }
        }
        abstractRStarTreeNode.setPageID(this.getRootID());
        E e = this.createNewDirectoryEntry(n);
        object = this.createNewDirectoryEntry(n2);
        abstractRStarTreeNode.addDirectoryEntry(e);
        abstractRStarTreeNode.addDirectoryEntry(object);
        this.writeNode(abstractRStarTreeNode);
        this.writeNode(n);
        this.writeNode(n2);
        if (this.getLogger().isDebugging()) {
            String string = "Create new Root: ID=" + abstractRStarTreeNode.getPageID();
            string = string + "\nchild1 " + n + " " + new HyperBoundingBox((SpatialComparable)e);
            string = string + "\nchild2 " + n2 + " " + new HyperBoundingBox((SpatialComparable)object);
            string = string + "\n";
            this.getLogger().debugFine(string);
        }
        return new IndexTreePath(null, this.getRootEntry(), -1);
    }

    protected IndexTreePath<E> containedTest(IndexTreePath<E> indexTreePath, N n, SpatialComparable spatialComparable) {
        SpatialEntry spatialEntry = null;
        int n2 = -1;
        double d = Double.NaN;
        for (int i = 0; i < ((AbstractNode)n).getNumEntries(); ++i) {
            SpatialEntry spatialEntry2 = (SpatialEntry)((AbstractNode)n).getEntry(i);
            if (!SpatialUtil.contains((SpatialComparable)spatialEntry2, spatialComparable)) continue;
            if (spatialEntry == null) {
                spatialEntry = spatialEntry2;
                n2 = i;
                continue;
            }
            double d2 = SpatialUtil.volume(spatialEntry2);
            if (Double.isNaN(d)) {
                d = SpatialUtil.volume(spatialEntry);
            }
            if (!(d2 < d)) continue;
            d = d2;
            spatialEntry = spatialEntry2;
            n2 = i;
        }
        return spatialEntry == null ? null : new IndexTreePath<Object>((IndexTreePath<Object>)indexTreePath, spatialEntry, n2);
    }

    protected IndexTreePath<E> choosePath(IndexTreePath<E> indexTreePath, SpatialComparable spatialComparable, int n, int n2) {
        AbstractRStarTreeNode abstractRStarTreeNode;
        if (this.getLogger().isDebuggingFiner()) {
            this.getLogger().debugFiner("node " + indexTreePath + ", depth " + n);
        }
        if ((abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(indexTreePath.getEntry())) == null) {
            throw new RuntimeException("Page file did not return node for node id: " + this.getPageID((Entry)indexTreePath.getEntry()));
        }
        if (abstractRStarTreeNode.isLeaf()) {
            return indexTreePath;
        }
        IndexTreePath<E> indexTreePath2 = this.containedTest(indexTreePath, abstractRStarTreeNode, spatialComparable);
        if (indexTreePath2 != null) {
            return ++n2 == n ? indexTreePath2 : this.choosePath(indexTreePath2, spatialComparable, n, n2);
        }
        AbstractRStarTreeNode abstractRStarTreeNode2 = (AbstractRStarTreeNode)this.getNode(abstractRStarTreeNode.getEntry(0));
        int n3 = ((AbstractRTreeSettings)this.settings).insertionStrategy.choose(abstractRStarTreeNode, NodeArrayAdapter.STATIC, spatialComparable, this.height, n2);
        indexTreePath2 = new IndexTreePath<E>(indexTreePath, abstractRStarTreeNode.getEntry(n3), n3);
        if (++n2 == n) {
            return indexTreePath2;
        }
        if (abstractRStarTreeNode2.isLeaf()) {
            assert (n2 == indexTreePath2.getPathCount());
            throw new IllegalArgumentException("childNode is leaf, but currentDepth != depth: " + n2 + " != " + n);
        }
        return this.choosePath(indexTreePath2, spatialComparable, n, n2);
    }

    private N overflowTreatment(N n, IndexTreePath<E> indexTreePath) {
        if (((AbstractRTreeSettings)this.settings).getOverflowTreatment().handleOverflow(this, n, indexTreePath)) {
            return null;
        }
        return this.split(n);
    }

    private N split(N n) {
        int n2 = ((AbstractNode)n).isLeaf() ? this.leafMinimum : this.dirMinimum;
        long[] lArray = ((AbstractRTreeSettings)this.settings).nodeSplitter.split(n, NodeArrayAdapter.STATIC, n2);
        AbstractRStarTreeNode abstractRStarTreeNode = ((AbstractNode)n).isLeaf() ? (AbstractRStarTreeNode)this.createNewLeafNode() : (AbstractRStarTreeNode)this.createNewDirectoryNode();
        ((AbstractNode)n).splitByMask(abstractRStarTreeNode, lArray);
        this.writeNode(n);
        this.writeNode(abstractRStarTreeNode);
        return (N)abstractRStarTreeNode;
    }

    public void reInsert(N n, IndexTreePath<E> indexTreePath, int[] nArray) {
        int n2;
        Object object;
        int n3 = indexTreePath.getPathCount();
        long[] lArray = BitsUtil.zero(((AbstractNode)n).getCapacity());
        ArrayList arrayList = new ArrayList(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(((AbstractNode)n).getEntry(nArray[i]));
            BitsUtil.setI(lArray, nArray[i]);
        }
        ((AbstractNode)n).removeMask(lArray);
        this.writeNode(n);
        IndexTreePath<E> indexTreePath2 = indexTreePath;
        Object object2 = n;
        while (indexTreePath2.getParentPath() != null && ((AbstractRStarTreeNode)object2).adjustEntry((SpatialEntry)((SpatialEntry)((AbstractNode)(object = (AbstractRStarTreeNode)this.getNode(indexTreePath2.getParentPath().getEntry()))).getEntry(n2 = indexTreePath2.getIndex())))) {
            this.writeNode(object);
            indexTreePath2 = indexTreePath2.getParentPath();
            object2 = object;
        }
        for (SpatialEntry spatialEntry : arrayList) {
            if (((AbstractNode)n).isLeaf()) {
                if (this.getLogger().isDebugging()) {
                    this.getLogger().debug("reinsert " + spatialEntry);
                }
                this.insertLeafEntry(spatialEntry);
                continue;
            }
            if (this.getLogger().isDebugging()) {
                this.getLogger().debug("reinsert " + spatialEntry + " at " + n3);
            }
            this.insertDirectoryEntry(spatialEntry, n3);
        }
    }

    protected void adjustTree(IndexTreePath<E> indexTreePath) {
        AbstractRStarTreeNode abstractRStarTreeNode;
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("Adjust tree " + indexTreePath);
        }
        if (this.hasOverflow(abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(indexTreePath.getEntry()))) {
            AbstractRStarTreeNode abstractRStarTreeNode2 = this.overflowTreatment(abstractRStarTreeNode, indexTreePath);
            if (abstractRStarTreeNode2 != null) {
                if (this.isRoot(abstractRStarTreeNode)) {
                    IndexTreePath<E> indexTreePath2 = this.createNewRoot(abstractRStarTreeNode, abstractRStarTreeNode2);
                    ++this.height;
                    this.adjustTree(indexTreePath2);
                } else {
                    AbstractRStarTreeNode abstractRStarTreeNode3 = (AbstractRStarTreeNode)this.getNode(indexTreePath.getParentPath().getEntry());
                    if (this.getLogger().isDebugging()) {
                        this.getLogger().debugFine("parent " + abstractRStarTreeNode3);
                    }
                    abstractRStarTreeNode3.addDirectoryEntry(this.createNewDirectoryEntry(abstractRStarTreeNode2));
                    abstractRStarTreeNode.adjustEntry((SpatialEntry)abstractRStarTreeNode3.getEntry(indexTreePath.getIndex()));
                    this.writeNode(abstractRStarTreeNode3);
                    this.adjustTree(indexTreePath.getParentPath());
                }
            }
        } else if (!this.isRoot(abstractRStarTreeNode)) {
            AbstractRStarTreeNode abstractRStarTreeNode4 = (AbstractRStarTreeNode)this.getNode(indexTreePath.getParentPath().getEntry());
            SpatialEntry spatialEntry = (SpatialEntry)abstractRStarTreeNode4.getEntry(indexTreePath.getIndex());
            boolean bl = abstractRStarTreeNode.adjustEntryIncremental(spatialEntry, (SpatialComparable)this.lastInsertedEntry);
            if (bl) {
                this.writeNode(abstractRStarTreeNode4);
                this.adjustTree(indexTreePath.getParentPath());
            }
        } else {
            abstractRStarTreeNode.adjustEntry((SpatialEntry)this.getRootEntry());
        }
    }

    private void condenseTree(IndexTreePath<E> indexTreePath, Stack<N> stack) {
        AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(indexTreePath.getEntry());
        if (!this.isRoot(abstractRStarTreeNode)) {
            AbstractRStarTreeNode abstractRStarTreeNode2 = (AbstractRStarTreeNode)this.getNode(indexTreePath.getParentPath().getEntry());
            int n = indexTreePath.getIndex();
            if (this.hasUnderflow(abstractRStarTreeNode)) {
                if (abstractRStarTreeNode2.deleteEntry(n)) {
                    stack.push(abstractRStarTreeNode);
                } else {
                    abstractRStarTreeNode.adjustEntry((SpatialEntry)abstractRStarTreeNode2.getEntry(n));
                }
            } else {
                abstractRStarTreeNode.adjustEntry((SpatialEntry)abstractRStarTreeNode2.getEntry(n));
            }
            this.writeNode(abstractRStarTreeNode2);
            this.condenseTree(indexTreePath.getParentPath(), stack);
        } else if (this.hasUnderflow(abstractRStarTreeNode) && abstractRStarTreeNode.getNumEntries() == 1 && !abstractRStarTreeNode.isLeaf()) {
            AbstractRStarTreeNode abstractRStarTreeNode3;
            AbstractRStarTreeNode abstractRStarTreeNode4 = (AbstractRStarTreeNode)this.getNode(abstractRStarTreeNode.getEntry(0));
            if (abstractRStarTreeNode4.isLeaf()) {
                abstractRStarTreeNode3 = (AbstractRStarTreeNode)this.createNewLeafNode();
                abstractRStarTreeNode3.setPageID(this.getRootID());
                for (int i = 0; i < abstractRStarTreeNode4.getNumEntries(); ++i) {
                    abstractRStarTreeNode3.addLeafEntry(abstractRStarTreeNode4.getEntry(i));
                }
            } else {
                abstractRStarTreeNode3 = (AbstractRStarTreeNode)this.createNewDirectoryNode();
                abstractRStarTreeNode3.setPageID(this.getRootID());
                for (int i = 0; i < abstractRStarTreeNode4.getNumEntries(); ++i) {
                    abstractRStarTreeNode3.addDirectoryEntry(abstractRStarTreeNode4.getEntry(i));
                }
            }
            this.writeNode(abstractRStarTreeNode3);
            --this.height;
        }
    }

    @Override
    public final List<E> getLeaves() {
        ArrayList arrayList = new ArrayList();
        if (this.height == 1) {
            arrayList.add(this.getRootEntry());
            return arrayList;
        }
        this.getLeafNodes((AbstractRStarTreeNode)this.getRoot(), arrayList, this.height);
        return arrayList;
    }

    private void getLeafNodes(N n, List<E> list, int n2) {
        if (n2 == 2) {
            for (int i = 0; i < ((AbstractNode)n).getNumEntries(); ++i) {
                list.add(((AbstractNode)n).getEntry(i));
            }
        } else {
            for (int i = 0; i < ((AbstractNode)n).getNumEntries(); ++i) {
                AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(((AbstractNode)n).getEntry(i));
                this.getLeafNodes(abstractRStarTreeNode, list, n2 - 1);
            }
        }
    }

    public void doExtraIntegrityChecks() {
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        Logging logging = this.getLogger();
        if (logging.isStatistics()) {
            logging.statistics(new LongStatistic(this.getClass().getName() + ".height", this.height));
            this.statistics.logStatistics();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.initialized) {
            Object object;
            AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)this.getRoot();
            int n5 = ((SpatialEntry)this.getRootEntry()).getDimensionality();
            while (!abstractRStarTreeNode.isLeaf()) {
                if (abstractRStarTreeNode.getNumEntries() <= 0) continue;
                object = (SpatialEntry)abstractRStarTreeNode.getEntry(0);
                abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(object);
                ++n4;
            }
            object = new BreadthFirstEnumeration(this, this.getRootPath());
            while (((BreadthFirstEnumeration)object).hasMoreElements()) {
                Object object2 = ((BreadthFirstEnumeration)object).nextElement();
                SpatialEntry spatialEntry = (SpatialEntry)((IndexTreePath)object2).getEntry();
                if (spatialEntry.isLeafEntry()) {
                    ++n3;
                    continue;
                }
                abstractRStarTreeNode = (AbstractRStarTreeNode)this.getNode(spatialEntry);
                if (abstractRStarTreeNode.isLeaf()) {
                    ++n2;
                    continue;
                }
                ++n;
            }
            stringBuilder.append(this.getClass().getName()).append(" has ").append(n4 + 1).append(" levels.\n");
            stringBuilder.append(n).append(" Directory Knoten (max = ").append(this.dirCapacity).append(", min = ").append(this.dirMinimum).append(")\n");
            stringBuilder.append(n2).append(" Daten Knoten (max = ").append(this.leafCapacity).append(", min = ").append(this.leafMinimum).append(")\n");
            stringBuilder.append(n3).append(' ').append(n5).append("-dim. Punkte im Baum \n");
        } else {
            stringBuilder.append(this.getClass().getName()).append(" is empty!\n");
        }
        return stringBuilder.toString();
    }

    public class Statistics {
        protected final Counter distanceCalcs;
        protected final Counter knnQueries;
        protected final Counter rangeQueries;

        public Statistics() {
            Logging logging = AbstractRStarTree.this.getLogger();
            String string = AbstractRStarTree.this.getClass().getName();
            this.distanceCalcs = logging.isStatistics() ? logging.newCounter(string + ".distancecalcs") : null;
            this.knnQueries = logging.isStatistics() ? logging.newCounter(string + ".knnqueries") : null;
            this.rangeQueries = logging.isStatistics() ? logging.newCounter(string + ".rangequeries") : null;
        }

        public void countDistanceCalculation() {
            if (this.distanceCalcs != null) {
                this.distanceCalcs.increment();
            }
        }

        public void countKNNQuery() {
            if (this.knnQueries != null) {
                this.knnQueries.increment();
            }
        }

        public void countRangeQuery() {
            if (this.rangeQueries != null) {
                this.rangeQueries.increment();
            }
        }

        public void logStatistics() {
            Logging logging = AbstractRStarTree.this.getLogger();
            if (AbstractRStarTree.this.statistics.distanceCalcs != null) {
                logging.statistics(AbstractRStarTree.this.statistics.distanceCalcs);
            }
            if (AbstractRStarTree.this.statistics.knnQueries != null) {
                logging.statistics(AbstractRStarTree.this.statistics.knnQueries);
            }
            if (AbstractRStarTree.this.statistics.rangeQueries != null) {
                logging.statistics(AbstractRStarTree.this.statistics.rangeQueries);
            }
        }
    }
}

