/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.kd;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="J. L. Bentley", title="Multidimensional binary search trees used for associative searching", booktitle="Communications of the ACM, Vol. 18 Issue 9, Sept. 1975", url="http://dx.doi.org/10.1145/361002.361007")
public class MinimalisticMemoryKDTree<O extends NumberVector>
extends AbstractIndex<O>
implements KNNIndex<O>,
RangeIndex<O> {
    private static final Logging LOG = Logging.getLogger(MinimalisticMemoryKDTree.class);
    ArrayModifiableDBIDs sorted = null;
    int dims = -1;
    int leafsize;
    final Counter objaccess;
    final Counter distcalc;

    public MinimalisticMemoryKDTree(Relation<O> relation, int n) {
        super(relation);
        this.leafsize = n;
        assert (n >= 1);
        if (LOG.isStatistics()) {
            String string = this.getClass().getName();
            this.objaccess = LOG.newCounter(string + ".objaccess");
            this.distcalc = LOG.newCounter(string + ".distancecalcs");
        } else {
            this.objaccess = null;
            this.distcalc = null;
        }
    }

    @Override
    public void initialize() {
        this.sorted = DBIDUtil.newArray(this.relation.getDBIDs());
        this.dims = RelationUtil.dimensionality(this.relation);
        VectorUtil.SortDBIDsBySingleDimension sortDBIDsBySingleDimension = this.objaccess != null ? new CountSortAccesses(this.objaccess, this.relation) : new VectorUtil.SortDBIDsBySingleDimension(this.relation);
        this.buildTree(0, this.sorted.size(), 0, sortDBIDsBySingleDimension);
    }

    private void buildTree(int n, int n2, int n3, VectorUtil.SortDBIDsBySingleDimension sortDBIDsBySingleDimension) {
        int n4 = n + n2 >>> 1;
        sortDBIDsBySingleDimension.setDimension(n3);
        QuickSelect.quickSelect(this.sorted, sortDBIDsBySingleDimension, n, n2, n4);
        int n5 = (n3 + 1) % this.dims;
        if (n + this.leafsize < n4) {
            this.buildTree(n, n4, n5, sortDBIDsBySingleDimension);
        }
        if (++n4 + this.leafsize < n2) {
            this.buildTree(n4, n2, n5, sortDBIDsBySingleDimension);
        }
    }

    @Override
    public String getLongName() {
        return "kd-tree";
    }

    @Override
    public String getShortName() {
        return "kd-tree";
    }

    @Override
    public void logStatistics() {
        if (this.objaccess != null) {
            LOG.statistics(this.objaccess);
        }
        if (this.distcalc != null) {
            LOG.statistics(this.distcalc);
        }
    }

    protected void countObjectAccess() {
        if (this.objaccess != null) {
            this.objaccess.increment();
        }
    }

    protected void countDistanceComputation() {
        if (this.distcalc != null) {
            this.distcalc.increment();
        }
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof LPNormDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)distanceFunction);
        }
        if (distanceFunction instanceof SquaredEuclideanDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)distanceFunction);
        }
        if (distanceFunction instanceof SparseLPNormDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)distanceFunction);
        }
        return null;
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof LPNormDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)distanceFunction);
        }
        if (distanceFunction instanceof SquaredEuclideanDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)distanceFunction);
        }
        if (distanceFunction instanceof SparseLPNormDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)distanceFunction);
        }
        return null;
    }

    @Alias(value={"minikd"})
    public static class Factory<O extends NumberVector>
    implements IndexFactory<O, MinimalisticMemoryKDTree<O>> {
        int leafsize;

        public Factory() {
            this(1);
        }

        public Factory(int n) {
            this.leafsize = n;
        }

        @Override
        public MinimalisticMemoryKDTree<O> instantiate(Relation<O> relation) {
            return new MinimalisticMemoryKDTree<O>(relation, this.leafsize);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer<O extends NumberVector>
        extends AbstractParameterizer {
            public static final OptionID LEAFSIZE_P = new OptionID("kd.leafsize", "Maximum leaf size for the k-d-tree. Nodes will be split until their size is smaller than this threshold.");
            int leafsize;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                IntParameter intParameter = (IntParameter)new IntParameter(LEAFSIZE_P, 1).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.leafsize = intParameter.intValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.leafsize);
            }
        }
    }

    public class KDTreeRangeQuery
    extends AbstractDistanceRangeQuery<O> {
        private Norm<? super O> norm;

        public KDTreeRangeQuery(DistanceQuery<O> distanceQuery, Norm<? super O> norm) {
            super(distanceQuery);
            this.norm = norm;
        }

        @Override
        public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            this.kdRangeSearch(0, MinimalisticMemoryKDTree.this.sorted.size(), 0, o, modifiableDoubleDBIDList, MinimalisticMemoryKDTree.this.sorted.iter(), d);
        }

        private void kdRangeSearch(int n, int n2, int n3, O o, ModifiableDoubleDBIDList modifiableDoubleDBIDList, DBIDArrayIter dBIDArrayIter, double d) {
            if (n2 - n <= MinimalisticMemoryKDTree.this.leafsize) {
                dBIDArrayIter.seek(n);
                while (dBIDArrayIter.getOffset() < n2) {
                    double d2 = this.norm.distance(o, this.relation.get(dBIDArrayIter));
                    MinimalisticMemoryKDTree.this.countObjectAccess();
                    MinimalisticMemoryKDTree.this.countDistanceComputation();
                    if (d2 <= d) {
                        modifiableDoubleDBIDList.add(d2, dBIDArrayIter);
                    }
                    dBIDArrayIter.advance();
                }
                return;
            }
            int n4 = n + n2 >>> 1;
            NumberVector numberVector = (NumberVector)this.relation.get(dBIDArrayIter.seek(n4));
            MinimalisticMemoryKDTree.this.countObjectAccess();
            double d3 = numberVector.doubleValue(n3) - o.doubleValue(n3);
            boolean bl = d3 >= 0.0;
            boolean bl2 = d3 <= 0.0;
            boolean bl3 = Math.abs(d3) <= d;
            int n5 = (n3 + 1) % MinimalisticMemoryKDTree.this.dims;
            if (bl3) {
                double d4 = this.norm.distance((NumberVector)o, numberVector);
                MinimalisticMemoryKDTree.this.countDistanceComputation();
                if (d4 <= d) {
                    assert (dBIDArrayIter.getOffset() == n4);
                    modifiableDoubleDBIDList.add(d4, dBIDArrayIter);
                }
            }
            if (n < n4 && (bl || bl3)) {
                this.kdRangeSearch(n, n4, n5, o, modifiableDoubleDBIDList, dBIDArrayIter, d);
            }
            if (n4 + 1 < n2 && (bl2 || bl3)) {
                this.kdRangeSearch(n4 + 1, n2, n5, o, modifiableDoubleDBIDList, dBIDArrayIter, d);
            }
        }
    }

    public class KDTreeKNNQuery
    extends AbstractDistanceKNNQuery<O> {
        private Norm<? super O> norm;

        public KDTreeKNNQuery(DistanceQuery<O> distanceQuery, Norm<? super O> norm) {
            super(distanceQuery);
            this.norm = norm;
        }

        @Override
        public KNNList getKNNForObject(O o, int n) {
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            this.kdKNNSearch(0, MinimalisticMemoryKDTree.this.sorted.size(), 0, o, kNNHeap, MinimalisticMemoryKDTree.this.sorted.iter(), Double.POSITIVE_INFINITY);
            return kNNHeap.toKNNList();
        }

        private double kdKNNSearch(int n, int n2, int n3, O o, KNNHeap kNNHeap, DBIDArrayIter dBIDArrayIter, double d) {
            if (n2 - n <= MinimalisticMemoryKDTree.this.leafsize) {
                dBIDArrayIter.seek(n);
                while (dBIDArrayIter.getOffset() < n2) {
                    double d2 = this.norm.distance(o, this.relation.get(dBIDArrayIter));
                    MinimalisticMemoryKDTree.this.countObjectAccess();
                    MinimalisticMemoryKDTree.this.countDistanceComputation();
                    if (d2 <= d) {
                        kNNHeap.insert(d2, dBIDArrayIter);
                    }
                    d = kNNHeap.getKNNDistance();
                    dBIDArrayIter.advance();
                }
                return d;
            }
            int n4 = n + n2 >>> 1;
            NumberVector numberVector = (NumberVector)this.relation.get(dBIDArrayIter.seek(n4));
            MinimalisticMemoryKDTree.this.countObjectAccess();
            double d3 = numberVector.doubleValue(n3) - o.doubleValue(n3);
            boolean bl = d3 >= 0.0;
            boolean bl2 = d3 <= 0.0;
            int n5 = (n3 + 1) % MinimalisticMemoryKDTree.this.dims;
            if (bl && bl2) {
                double d4 = this.norm.distance((NumberVector)o, numberVector);
                MinimalisticMemoryKDTree.this.countDistanceComputation();
                if (d4 <= d) {
                    assert (dBIDArrayIter.getOffset() == n4);
                    kNNHeap.insert(d4, dBIDArrayIter);
                    d = kNNHeap.getKNNDistance();
                }
                if (n < n4) {
                    d = this.kdKNNSearch(n, n4, n5, o, kNNHeap, dBIDArrayIter, d);
                }
                if (n4 + 1 < n2) {
                    d = this.kdKNNSearch(n4 + 1, n2, n5, o, kNNHeap, dBIDArrayIter, d);
                }
            } else if (bl) {
                if (n < n4) {
                    d = this.kdKNNSearch(n, n4, n5, o, kNNHeap, dBIDArrayIter, d);
                }
                if (Math.abs(d3) <= d) {
                    double d5 = this.norm.distance((NumberVector)o, numberVector);
                    MinimalisticMemoryKDTree.this.countDistanceComputation();
                    if (d5 <= d) {
                        kNNHeap.insert(d5, dBIDArrayIter.seek(n4));
                        d = kNNHeap.getKNNDistance();
                    }
                }
                if (n4 + 1 < n2 && Math.abs(d3) <= d) {
                    d = this.kdKNNSearch(n4 + 1, n2, n5, o, kNNHeap, dBIDArrayIter, d);
                }
            } else {
                if (n4 + 1 < n2) {
                    d = this.kdKNNSearch(n4 + 1, n2, n5, o, kNNHeap, dBIDArrayIter, d);
                }
                if (Math.abs(d3) <= d) {
                    double d6 = this.norm.distance((NumberVector)o, numberVector);
                    MinimalisticMemoryKDTree.this.countDistanceComputation();
                    if (d6 <= d) {
                        kNNHeap.insert(d6, dBIDArrayIter.seek(n4));
                        d = kNNHeap.getKNNDistance();
                    }
                }
                if (n < n4 && Math.abs(d3) <= d) {
                    d = this.kdKNNSearch(n, n4, n5, o, kNNHeap, dBIDArrayIter, d);
                }
            }
            return d;
        }
    }

    private static class CountSortAccesses
    extends VectorUtil.SortDBIDsBySingleDimension {
        final Counter objaccess;

        public CountSortAccesses(Counter counter, Relation<? extends NumberVector> relation) {
            super(relation);
            this.objaccess = counter;
        }

        @Override
        public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            this.objaccess.increment(2L);
            return super.compare(dBIDRef, dBIDRef2);
        }
    }
}

