/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.AbstractLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SpatialPointLeafEntry
extends AbstractLeafEntry
implements SpatialEntry,
NumberVector {
    private static final long serialVersionUID = 1L;
    private double[] values;

    public SpatialPointLeafEntry() {
    }

    public SpatialPointLeafEntry(DBID dBID, double[] dArray) {
        super(dBID);
        this.values = dArray;
    }

    public SpatialPointLeafEntry(DBID dBID, NumberVector numberVector) {
        super(dBID);
        int n = numberVector.getDimensionality();
        this.values = new double[n];
        for (int i = 0; i < n; ++i) {
            this.values[i] = numberVector.doubleValue(i);
        }
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    public double getMin(int n) {
        return this.values[n];
    }

    @Override
    public double getMax(int n) {
        return this.values[n];
    }

    public double[] getValues() {
        return this.values;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.values.length);
        for (double d : this.values) {
            objectOutput.writeDouble(d);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.values = new double[objectInput.readInt()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = objectInput.readDouble();
        }
    }

    @Override
    @Deprecated
    public Double getValue(int n) {
        return this.values[n];
    }

    @Override
    public double doubleValue(int n) {
        return this.values[n];
    }

    @Override
    public float floatValue(int n) {
        return (float)this.values[n];
    }

    @Override
    public int intValue(int n) {
        return (int)this.values[n];
    }

    @Override
    public long longValue(int n) {
        return (long)this.values[n];
    }

    @Override
    public short shortValue(int n) {
        return (short)this.values[n];
    }

    @Override
    public byte byteValue(int n) {
        return (byte)this.values[n];
    }

    @Override
    public Vector getColumnVector() {
        return new Vector((double[])this.values.clone());
    }
}

