/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.Assignments;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;

public abstract class MTreeSplit<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry> {
    protected double[] computeDistanceMatrix(AbstractMTree<O, N, E, ?> abstractMTree, N n) {
        int n2 = ((AbstractNode)n).getNumEntries();
        double[] dArray = new double[n2 * n2];
        for (int i = 0; i < n2; ++i) {
            MTreeEntry mTreeEntry = (MTreeEntry)((AbstractNode)n).getEntry(i);
            int n3 = i + 1;
            int n4 = i * n2 + n3;
            while (n3 < n2) {
                double d;
                dArray[n4] = d = abstractMTree.distance(mTreeEntry, (MTreeEntry)((AbstractNode)n).getEntry(n3));
                dArray[n3 * n2 + i] = d;
                ++n3;
                ++n4;
            }
        }
        return dArray;
    }

    Assignments<E> balancedPartition(AbstractMTree<O, N, E, ?> abstractMTree, N n, DBID dBID, DBID dBID2) {
        assert (dBID != null && dBID2 != null);
        int n2 = ((AbstractNode)n).getNumEntries();
        int n3 = n2 - 2;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        Assignments<MTreeEntry> assignments = new Assignments<MTreeEntry>(n2 + 1 >> 1);
        assignments.setFirstRoutingObject(dBID);
        assignments.setSecondRoutingObject(dBID2);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            MTreeEntry mTreeEntry = (MTreeEntry)((AbstractNode)n).getEntry(i);
            DBID dBID3 = mTreeEntry.getRoutingObjectID();
            if (DBIDUtil.equal(dBID3, dBID)) {
                assignments.addToFirst(mTreeEntry, 0.0, i);
                continue;
            }
            if (DBIDUtil.equal(dBID3, dBID2)) {
                assignments.addToSecond(mTreeEntry, 0.0, i);
                continue;
            }
            dArray[n4] = abstractMTree.distance(dBID, dBID3);
            nArray[n4] = i;
            dArray2[n4] = abstractMTree.distance(dBID2, dBID3);
            nArray2[n4] = i;
            ++n4;
        }
        DoubleIntegerArrayQuickSort.sort(dArray, nArray, n3);
        DoubleIntegerArrayQuickSort.sort(dArray2, nArray2, n3);
        long[] lArray = BitsUtil.zero(n2);
        n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 = this.assignBest(assignments, lArray, n, dArray, nArray, n4, false);
            if (++i >= n3) continue;
            n5 = this.assignBest(assignments, lArray, n, dArray2, nArray2, n5, true);
        }
        assert (assignments.getFirstAssignments().size() + assignments.getSecondAssignments().size() == n2) : "Sizes do not sum up: " + assignments.getFirstAssignments().size() + " + " + assignments.getFirstAssignments().size() + " != " + n2;
        assert (Math.abs(assignments.getFirstAssignments().size() - assignments.getSecondAssignments().size()) <= 1) : assignments.getFirstAssignments().size() + " " + assignments.getSecondAssignments().size();
        return assignments;
    }

    Assignments<E> balancedPartition(AbstractMTree<O, N, E, ?> abstractMTree, N n, int n2, int n3, double[] dArray) {
        int n4 = ((AbstractNode)n).getNumEntries();
        int n5 = n4 - 2;
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5];
        Assignments<MTreeEntry> assignments = new Assignments<MTreeEntry>(n4 + 1 >> 1);
        int n6 = 0;
        for (int i = 0; i < ((AbstractNode)n).getNumEntries(); ++i) {
            MTreeEntry mTreeEntry = (MTreeEntry)((AbstractNode)n).getEntry(i);
            if (i == n2) {
                assignments.setFirstRoutingObject(mTreeEntry.getRoutingObjectID());
                assignments.addToFirst(mTreeEntry, 0.0, i);
                continue;
            }
            if (i == n3) {
                assignments.setSecondRoutingObject(mTreeEntry.getRoutingObjectID());
                assignments.addToSecond(mTreeEntry, 0.0, i);
                continue;
            }
            dArray2[n6] = dArray[i * n4 + n2];
            nArray[n6] = i;
            dArray3[n6] = dArray[i * n4 + n3];
            nArray2[n6] = i;
            ++n6;
        }
        DoubleIntegerArrayQuickSort.sort(dArray2, nArray, n5);
        DoubleIntegerArrayQuickSort.sort(dArray3, nArray2, n5);
        long[] lArray = BitsUtil.zero(n4);
        n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            n6 = this.assignBest(assignments, lArray, n, dArray2, nArray, n6, false);
            if (++i >= n5) continue;
            n7 = this.assignBest(assignments, lArray, n, dArray3, nArray2, n7, true);
        }
        assert (assignments.getFirstAssignments().size() + assignments.getSecondAssignments().size() == n4) : "Sizes do not sum up: " + assignments.getFirstAssignments().size() + " + " + assignments.getFirstAssignments().size() + " != " + n4;
        assert (Math.abs(assignments.getFirstAssignments().size() - assignments.getSecondAssignments().size()) <= 1) : assignments.getFirstAssignments().size() + " " + assignments.getSecondAssignments().size();
        return assignments;
    }

    private int assignBest(Assignments<E> assignments, long[] lArray, N n, double[] dArray, int[] nArray, int n2, boolean bl) {
        int n3 = nArray[n2];
        while (BitsUtil.get(lArray, n3)) {
            n3 = nArray[++n2];
        }
        if (bl) {
            assignments.addToSecond((MTreeEntry)((AbstractNode)n).getEntry(n3), dArray[n2], n3);
        } else {
            assignments.addToFirst((MTreeEntry)((AbstractNode)n).getEntry(n3), dArray[n2], n3);
        }
        BitsUtil.setI(lArray, n3);
        return ++n2;
    }

    public abstract Assignments<E> split(AbstractMTree<O, N, E, ?> var1, N var2);
}

