/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class MkTabLeafEntry
extends MTreeLeafEntry
implements MkTabEntry {
    private static final long serialVersionUID = 2L;
    private double[] knnDistances;

    public MkTabLeafEntry() {
    }

    public MkTabLeafEntry(DBID dBID, double d, double[] dArray) {
        super(dBID, d);
        this.knnDistances = dArray;
    }

    @Override
    public double[] getKnnDistances() {
        return this.knnDistances;
    }

    @Override
    public void setKnnDistances(double[] dArray) {
        if (dArray.length != this.knnDistances.length) {
            throw new IllegalArgumentException("Wrong length of knn distances: " + dArray.length);
        }
        this.knnDistances = dArray;
    }

    @Override
    public double getKnnDistance(int n) {
        if (n >= this.knnDistances.length) {
            throw new IllegalArgumentException("Parameter k = " + n + " is not supported!");
        }
        return this.knnDistances[n - 1];
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        int n = this.knnDistances.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeDouble(this.knnDistances[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.knnDistances = new double[n];
        for (int i = 0; i < n; ++i) {
            this.knnDistances[i] = objectInput.readDouble();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MkTabLeafEntry mkTabLeafEntry = (MkTabLeafEntry)object;
        if (this.knnDistances.length != mkTabLeafEntry.knnDistances.length) {
            return false;
        }
        return !(this.knnDistances == null ? mkTabLeafEntry.knnDistances != null : !this.knnDistances.equals(mkTabLeafEntry.knnDistances));
    }
}

