/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeFactory;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeSettings;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class MkAppTreeFactory<O>
extends AbstractMTreeFactory<O, MkAppTreeNode<O>, MkAppEntry, MkAppTreeIndex<O>, MkAppTreeSettings<O>> {
    public static final OptionID NOLOG_ID = new OptionID("mkapp.nolog", "Flag to indicate that the approximation is done in the ''normal'' space instead of the log-log space (which is default).");
    public static final OptionID K_ID = new OptionID("mkapp.k", "positive integer specifying the maximum number k of reverse k nearest neighbors to be supported.");
    public static final OptionID P_ID = new OptionID("mkapp.p", "positive integer specifying the order of the polynomial approximation.");

    public MkAppTreeFactory(PageFileFactory<?> pageFileFactory, MkAppTreeSettings<O> mkAppTreeSettings) {
        super(pageFileFactory, mkAppTreeSettings);
    }

    @Override
    public MkAppTreeIndex<O> instantiate(Relation<O> relation) {
        PageFile<MkAppTreeNode<O>> pageFile = this.makePageFile(this.getNodeClass());
        return new MkAppTreeIndex<O>(relation, pageFile, (MkAppTreeSettings)this.settings);
    }

    protected Class<MkAppTreeNode<O>> getNodeClass() {
        return ClassGenericsUtil.uglyCastIntoSubclass(MkAppTreeNode.class);
    }

    public static class Parameterizer<O>
    extends AbstractMTreeFactory.Parameterizer<O, MkAppTreeNode<O>, MkAppEntry, MkAppTreeSettings<O>> {
        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                ((MkAppTreeSettings)this.settings).k_max = (Integer)intParameter.getValue();
            }
            IntParameter intParameter2 = new IntParameter(P_ID);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                ((MkAppTreeSettings)this.settings).p = (Integer)intParameter2.getValue();
            }
            if (parameterization.grab(flag = new Flag(NOLOG_ID))) {
                ((MkAppTreeSettings)this.settings).log = (Boolean)flag.getValue() == false;
            }
        }

        @Override
        protected MkAppTreeFactory<O> makeInstance() {
            return new MkAppTreeFactory(this.pageFileFactory, (MkAppTreeSettings)this.settings);
        }

        @Override
        protected MkAppTreeSettings<O> makeSettings() {
            return new MkAppTreeSettings();
        }
    }
}

