/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree;

import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.tree.DirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.Node;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public abstract class IndexTree<N extends Node<E>, E extends Entry>
implements Index {
    private final PageFile<N> file;
    protected boolean initialized = false;
    protected int dirCapacity;
    protected int leafCapacity;
    protected int dirMinimum;
    protected int leafMinimum;
    private E rootEntry;

    public IndexTree(PageFile<N> pageFile) {
        this.file = pageFile;
    }

    @Override
    public void initialize() {
        TreeIndexHeader treeIndexHeader = this.createHeader();
        if (this.file.initialize(treeIndexHeader)) {
            this.initializeFromFile(treeIndexHeader, this.file);
        }
        this.rootEntry = this.createRootEntry();
    }

    protected abstract Logging getLogger();

    public final E getRootEntry() {
        return this.rootEntry;
    }

    public final int getRootID() {
        return this.getPageID((Entry)this.rootEntry);
    }

    public N getRoot() {
        return (N)((Node)this.file.readPage(this.getPageID((Entry)this.rootEntry)));
    }

    protected boolean isRoot(N n) {
        return this.getRootID() == n.getPageID();
    }

    protected int getPageID(Entry entry) {
        if (entry.isLeafEntry()) {
            throw new AbortException("Leafs do not have page ids!");
        }
        return ((DirectoryEntry)entry).getPageID();
    }

    public N getNode(int n) {
        if (n == this.getPageID((Entry)this.rootEntry)) {
            return this.getRoot();
        }
        return (N)((Node)this.file.readPage(n));
    }

    public final N getNode(E e) {
        return this.getNode((E)this.getPageID((Entry)e));
    }

    protected void writeNode(N n) {
        this.file.writePage(n);
    }

    protected void deleteNode(N n) {
        this.file.deletePage(n.getPageID());
    }

    protected TreeIndexHeader createHeader() {
        return new TreeIndexHeader(this.file.getPageSize(), this.dirCapacity, this.leafCapacity, this.dirMinimum, this.leafMinimum);
    }

    public void initializeFromFile(TreeIndexHeader treeIndexHeader, PageFile<N> pageFile) {
        this.dirCapacity = treeIndexHeader.getDirCapacity();
        this.leafCapacity = treeIndexHeader.getLeafCapacity();
        this.dirMinimum = treeIndexHeader.getDirMinimum();
        this.leafMinimum = treeIndexHeader.getLeafMinimum();
        if (this.getLogger().isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass());
            stringBuilder.append("\n file = ").append(pageFile.getClass());
            this.getLogger().debugFine(stringBuilder.toString());
        }
        this.initialized = true;
    }

    protected final void initialize(E e) {
        this.initializeCapacities(e);
        this.createEmptyRoot(e);
        Logging logging = this.getLogger();
        if (logging.isStatistics()) {
            String string = this.getClass().getName();
            logging.statistics(new LongStatistic(string + ".directory.capacity", this.dirCapacity));
            logging.statistics(new LongStatistic(string + ".directory.minfill", this.dirMinimum));
            logging.statistics(new LongStatistic(string + ".leaf.capacity", this.leafCapacity));
            logging.statistics(new LongStatistic(string + ".leaf.minfill", this.leafMinimum));
        }
        this.initialized = true;
    }

    public final IndexTreePath<E> getRootPath() {
        return new IndexTreePath<E>(null, this.rootEntry, -1);
    }

    protected abstract void initializeCapacities(E var1);

    protected abstract void createEmptyRoot(E var1);

    protected abstract E createRootEntry();

    protected abstract N createNewLeafNode();

    protected abstract N createNewDirectoryNode();

    protected void preInsert(E e) {
    }

    protected void postDelete(E e) {
    }

    @Override
    public void logStatistics() {
        this.file.logStatistics();
    }

    protected int getPageSize() {
        return this.file.getPageSize();
    }

    @Deprecated
    protected PageFile<N> getFile() {
        return this.file;
    }
}

