/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree;

import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.IndexTree;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.Node;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class BreadthFirstEnumeration<N extends Node<E>, E extends Entry>
implements Enumeration<IndexTreePath<E>> {
    public final Enumeration<IndexTreePath<E>> EMPTY_ENUMERATION = new Enumeration<IndexTreePath<E>>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public IndexTreePath<E> nextElement() {
            throw new NoSuchElementException("No more children");
        }
    };
    private Queue<Enumeration<IndexTreePath<E>>> queue = new LinkedList<Enumeration<IndexTreePath<E>>>();
    private IndexTree<N, E> index;

    public BreadthFirstEnumeration(IndexTree<N, E> indexTree, final IndexTreePath<E> indexTreePath) {
        this.index = indexTree;
        Enumeration enumeration = new Enumeration<IndexTreePath<E>>(){
            boolean hasNext = true;

            @Override
            public boolean hasMoreElements() {
                return this.hasNext;
            }

            @Override
            public IndexTreePath<E> nextElement() {
                this.hasNext = false;
                return indexTreePath;
            }
        };
        this.queue.offer(enumeration);
    }

    @Override
    public boolean hasMoreElements() {
        return !this.queue.isEmpty() && this.queue.peek().hasMoreElements();
    }

    @Override
    public IndexTreePath<E> nextElement() {
        Enumeration<IndexTreePath<E>> enumeration;
        Enumeration<IndexTreePath<E>> enumeration2 = this.queue.peek();
        IndexTreePath<E> indexTreePath = enumeration2.nextElement();
        if (indexTreePath.getEntry().isLeafEntry()) {
            enumeration = this.EMPTY_ENUMERATION;
        } else {
            N n = this.index.getNode(indexTreePath.getEntry());
            enumeration = n.children(indexTreePath);
        }
        if (!enumeration2.hasMoreElements()) {
            this.queue.remove();
        }
        if (enumeration.hasMoreElements()) {
            this.queue.offer(enumeration);
        }
        return indexTreePath;
    }
}

