/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.preference;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.APRIORI;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.HashmapDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.OnedimensionalDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.AbstractPreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.PreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.result.FrequentItemsetsResult;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Description(value="Computes the preference vector of objects of a certain database according to the DiSH algorithm.")
public class DiSHPreferenceVectorIndex<V extends NumberVector>
extends AbstractPreferenceVectorIndex<V>
implements PreferenceVectorIndex<V> {
    private static final Logging LOG = Logging.getLogger(DiSHPreferenceVectorIndex.class);
    protected double[] epsilon;
    protected int minpts;
    protected Strategy strategy;

    public DiSHPreferenceVectorIndex(Relation<V> relation, double[] dArray, int n, Strategy strategy) {
        super(relation);
        this.epsilon = dArray;
        this.minpts = n;
        this.strategy = strategy;
    }

    @Override
    public void initialize() {
        if (this.relation == null || this.relation.size() == 0) {
            throw new IllegalArgumentException("database empty: must contain elements");
        }
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, long[].class);
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n eps ").append(Arrays.asList(new double[][]{this.epsilon}));
            stringBuilder.append("\n minpts ").append(this.minpts);
            stringBuilder.append("\n strategy ").append((Object)this.strategy);
            LOG.debugFine(stringBuilder.toString());
        }
        long l = System.currentTimeMillis();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Preprocessing preference vector", this.relation.size(), LOG) : null;
        int n = RelationUtil.dimensionality(this.relation);
        if (this.epsilon.length == 1 && n != 1) {
            double d = this.epsilon[0];
            this.epsilon = new double[n];
            Arrays.fill(this.epsilon, d);
        }
        RangeQuery<V>[] rangeQueryArray = this.initRangeQueries(this.relation, n);
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            if (LOG.isDebugging()) {
                stringBuilder.append("\nid = ").append(DBIDUtil.toString(dBIDIter));
            }
            ModifiableDBIDs[] modifiableDBIDsArray = new ModifiableDBIDs[n];
            for (n2 = 0; n2 < n; ++n2) {
                DoubleDBIDList doubleDBIDList = rangeQueryArray[n2].getRangeForDBID(dBIDIter, this.epsilon[n2]);
                modifiableDBIDsArray[n2] = DBIDUtil.newHashSet(doubleDBIDList);
            }
            if (LOG.isDebugging()) {
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuilder.append("\n neighbors [").append(n2).append(']');
                    stringBuilder.append(" (").append(modifiableDBIDsArray[n2].size()).append(") = ");
                    stringBuilder.append(modifiableDBIDsArray[n2]);
                }
            }
            this.storage.put(dBIDIter, this.determinePreferenceVector(this.relation, modifiableDBIDsArray, stringBuilder));
            if (LOG.isDebugging()) {
                LOG.debugFine(stringBuilder.toString());
            }
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        long l2 = System.currentTimeMillis();
        if (LOG.isVerbose()) {
            long l3 = l2 - l;
            LOG.verbose(this.getClass().getName() + " runtime: " + l3 + " milliseconds.");
        }
    }

    private long[] determinePreferenceVector(Relation<V> relation, ModifiableDBIDs[] modifiableDBIDsArray, StringBuilder stringBuilder) {
        if (this.strategy.equals((Object)Strategy.APRIORI)) {
            return this.determinePreferenceVectorByApriori(relation, modifiableDBIDsArray, stringBuilder);
        }
        if (this.strategy.equals((Object)Strategy.MAX_INTERSECTION)) {
            return this.determinePreferenceVectorByMaxIntersection(modifiableDBIDsArray, stringBuilder);
        }
        throw new IllegalStateException("Should never happen!");
    }

    private long[] determinePreferenceVectorByApriori(Relation<V> relation, ModifiableDBIDs[] modifiableDBIDsArray, StringBuilder stringBuilder) {
        int n;
        Object object;
        int n2 = modifiableDBIDsArray.length;
        HashmapDatabase hashmapDatabase = new HashmapDatabase();
        VectorFieldTypeInformation<BitVector> vectorFieldTypeInformation = VectorFieldTypeInformation.typeRequest(BitVector.class, n2, n2);
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            object = BitsUtil.zero(n2);
            boolean bl = true;
            for (n = 0; n < n2; ++n) {
                if (!modifiableDBIDsArray[n].contains((DBIDRef)object2)) continue;
                BitsUtil.setI((long[])object, n);
                bl = false;
            }
            if (!bl) {
                SingleObjectBundle singleObjectBundle = new SingleObjectBundle();
                singleObjectBundle.append(vectorFieldTypeInformation, new BitVector((long[])object, n2));
                hashmapDatabase.insert(singleObjectBundle);
            }
            object2.advance();
        }
        object2 = new APRIORI(this.minpts);
        object = (FrequentItemsetsResult)((AbstractAlgorithm)object2).run(hashmapDatabase);
        List<Itemset> list = ((FrequentItemsetsResult)object).getItemsets();
        if (LOG.isDebugging()) {
            stringBuilder.append("\n Frequent itemsets: ").append(list);
        }
        n = 0;
        int n3 = 0;
        long[] lArray = BitsUtil.zero(n2);
        for (Itemset itemset : list) {
            if (n3 >= itemset.length() && (n3 != itemset.length() || n != itemset.getSupport())) continue;
            lArray = itemset.getItems();
            n3 = itemset.length();
            n = itemset.getSupport();
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\n preference ");
            stringBuilder.append(BitsUtil.toStringLow(lArray, n2));
            stringBuilder.append('\n');
            LOG.debugFine(stringBuilder.toString());
        }
        return lArray;
    }

    private long[] determinePreferenceVectorByMaxIntersection(ModifiableDBIDs[] modifiableDBIDsArray, StringBuilder stringBuilder) {
        ModifiableDBIDs modifiableDBIDs;
        int n;
        int n2 = modifiableDBIDsArray.length;
        long[] lArray = BitsUtil.zero(n2);
        HashMap<Integer, ModifiableDBIDs> hashMap = new HashMap<Integer, ModifiableDBIDs>(n2);
        for (n = 0; n < n2; ++n) {
            modifiableDBIDs = modifiableDBIDsArray[n];
            if (modifiableDBIDs.size() <= this.minpts) continue;
            hashMap.put(n, modifiableDBIDs);
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\n candidates ").append(hashMap.keySet());
        }
        if (!hashMap.isEmpty()) {
            n = this.max(hashMap);
            modifiableDBIDs = (ModifiableDBIDs)hashMap.remove(n);
            BitsUtil.setI(lArray, n);
            while (!hashMap.isEmpty()) {
                ModifiableDBIDs modifiableDBIDs2 = DBIDUtil.newHashSet();
                n = this.maxIntersection(hashMap, modifiableDBIDs, modifiableDBIDs2);
                ModifiableDBIDs modifiableDBIDs3 = (ModifiableDBIDs)hashMap.remove(n);
                if ((modifiableDBIDs = (modifiableDBIDs2 = DBIDUtil.intersection(modifiableDBIDs, modifiableDBIDs3))).size() < this.minpts) break;
                BitsUtil.setI(lArray, n);
            }
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\n preference ");
            stringBuilder.append(BitsUtil.toStringLow(lArray, n2));
            stringBuilder.append('\n');
            LOG.debug(stringBuilder.toString());
        }
        return lArray;
    }

    private int max(Map<Integer, ModifiableDBIDs> map) {
        DBIDs dBIDs = null;
        Integer n = null;
        for (Integer n2 : map.keySet()) {
            DBIDs dBIDs2 = map.get(n2);
            if (dBIDs != null && dBIDs.size() >= dBIDs2.size()) continue;
            dBIDs = dBIDs2;
            n = n2;
        }
        return n;
    }

    private int maxIntersection(Map<Integer, ModifiableDBIDs> map, DBIDs dBIDs, ModifiableDBIDs modifiableDBIDs) {
        Integer n = null;
        for (Integer n2 : map.keySet()) {
            DBIDs dBIDs2 = map.get(n2);
            ModifiableDBIDs modifiableDBIDs2 = DBIDUtil.intersection(dBIDs, dBIDs2);
            if (modifiableDBIDs.size() >= modifiableDBIDs2.size()) continue;
            modifiableDBIDs = modifiableDBIDs2;
            n = n2;
        }
        return n;
    }

    private RangeQuery<V>[] initRangeQueries(Relation<V> relation, int n) {
        Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(RangeQuery.class);
        RangeQuery[] rangeQueryArray = (RangeQuery[])ClassGenericsUtil.newArrayOfNull(n, clazz);
        for (int i = 0; i < n; ++i) {
            rangeQueryArray[i] = relation.getRangeQuery(new PrimitiveDistanceQuery<NumberVector>(relation, new OnedimensionalDistanceFunction(i)), new Object[0]);
        }
        return rangeQueryArray;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "DiSH Preference Vectors";
    }

    @Override
    public String getShortName() {
        return "dish-pref";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<V extends NumberVector>
    extends AbstractPreferenceVectorIndex.Factory<V, DiSHPreferenceVectorIndex<V>> {
        public static final double DEFAULT_EPSILON = 0.001;
        public static final OptionID EPSILON_ID = new OptionID("dish.epsilon", "A comma separated list of positive doubles specifying the maximum radius of the neighborhood to be considered in each dimension for determination of the preference vector (default is 0.001 in each dimension). If only one value is specified, this value will be used for each dimension.");
        public static final String MINPTS_P = "dish.minpts";
        private static final String CONDITION = "The value of the preference vector in dimension d_i is set to 1 if the epsilon neighborhood contains more than dish.minpts points and the following condition holds: for all dimensions d_j: |neighbors(d_i) intersection neighbors(d_j)| >= dish.minpts.";
        public static final OptionID MINPTS_ID = new OptionID("dish.minpts", "Positive threshold for minumum numbers of points in the epsilon-neighborhood of a point. The value of the preference vector in dimension d_i is set to 1 if the epsilon neighborhood contains more than dish.minpts points and the following condition holds: for all dimensions d_j: |neighbors(d_i) intersection neighbors(d_j)| >= dish.minpts.");
        public static final Strategy DEFAULT_STRATEGY = Strategy.MAX_INTERSECTION;
        public static final OptionID STRATEGY_ID = new OptionID("dish.strategy", "The strategy for determination of the preference vector, available strategies are: [" + (Object)((Object)Strategy.APRIORI) + "| " + (Object)((Object)Strategy.MAX_INTERSECTION) + "]" + "(default is " + (Object)((Object)DEFAULT_STRATEGY) + ")");
        protected double[] epsilon;
        protected int minpts;
        protected Strategy strategy;

        public Factory(double[] dArray, int n, Strategy strategy) {
            this.epsilon = dArray;
            this.minpts = n;
            this.strategy = strategy;
        }

        @Override
        public DiSHPreferenceVectorIndex<V> instantiate(Relation<V> relation) {
            return new DiSHPreferenceVectorIndex<V>(relation, this.epsilon, this.minpts, this.strategy);
        }

        public int getMinpts() {
            return this.minpts;
        }

        public static class Parameterizer<V extends NumberVector>
        extends AbstractParameterizer {
            protected double[] epsilon;
            protected int minpts;
            protected Strategy strategy;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                EnumParameter<Strategy> enumParameter;
                DoubleListParameter doubleListParameter;
                super.makeOptions(parameterization);
                IntParameter intParameter = (IntParameter)new IntParameter(MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.minpts = (Integer)intParameter.getValue();
                }
                if (parameterization.grab(doubleListParameter = (DoubleListParameter)new DoubleListParameter(EPSILON_ID, true).setDefaultValue(new double[]{0.001}))) {
                    this.epsilon = (double[])((double[])doubleListParameter.getValue()).clone();
                    for (int i = 0; i < this.epsilon.length; ++i) {
                        if (!(this.epsilon[i] < 0.0)) continue;
                        parameterization.reportError(new WrongParameterValueException(doubleListParameter, doubleListParameter.getValueAsString()));
                    }
                }
                if (parameterization.grab(enumParameter = new EnumParameter<Strategy>(STRATEGY_ID, Strategy.class, DEFAULT_STRATEGY))) {
                    this.strategy = (Strategy)((Object)enumParameter.getValue());
                }
            }

            @Override
            protected Factory<V> makeInstance() {
                return new Factory(this.epsilon, this.minpts, this.strategy);
            }
        }
    }

    public static enum Strategy {
        APRIORI,
        MAX_INTERSECTION;

    }
}

