/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Random;

@Reference(title="Subsampling for Efficient and Effective Unsupervised Outlier Detection Ensembles", authors="A. Zimek and M. Gaudet and R. J. G. B. Campello and J. Sander", booktitle="Proc. 19th ACM SIGKDD International Conference on Knowledge Discovery and Data Mining, KDD '13")
public class RandomSampleKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(RandomSampleKNNPreprocessor.class);
    private final double share;
    private final RandomFactory rnd;

    public RandomSampleKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int n, double d, RandomFactory randomFactory) {
        super(relation, distanceFunction, n);
        this.share = d;
        this.rnd = randomFactory;
    }

    @Override
    protected void preprocess() {
        DistanceQuery distanceQuery = this.relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 4, KNNList.class);
        FiniteProgress finiteProgress = this.getLogger().isVerbose() ? new FiniteProgress("Materializing random-sample k nearest neighbors (k=" + this.k + ")", this.relation.size(), this.getLogger()) : null;
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(this.relation.getDBIDs());
        int n = (int)((double)arrayDBIDs.size() * this.share);
        Random random = this.rnd.getSingleThreadedRandom();
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            KNNHeap kNNHeap = DBIDUtil.newHeap(this.k);
            ModifiableDBIDs modifiableDBIDs = DBIDUtil.randomSample((DBIDs)arrayDBIDs, n, random);
            DBIDIter dBIDIter = modifiableDBIDs.iter();
            while (dBIDIter.valid()) {
                double d = distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDIter);
                kNNHeap.insert(d, dBIDIter);
                dBIDIter.advance();
            }
            this.storage.put(dBIDArrayIter, kNNHeap.toKNNList());
            this.getLogger().incrementProcessed(finiteProgress);
            dBIDArrayIter.advance();
        }
        this.getLogger().ensureCompleted(finiteProgress);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "random sample kNN";
    }

    @Override
    public String getShortName() {
        return "random-sample-knn";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        private final double share;
        private final RandomFactory rnd;

        public Factory(int n, DistanceFunction<? super O> distanceFunction, double d, RandomFactory randomFactory) {
            super(n, distanceFunction);
            this.share = d;
            this.rnd = randomFactory;
        }

        @Override
        public RandomSampleKNNPreprocessor<O> instantiate(Relation<O> relation) {
            return new RandomSampleKNNPreprocessor<O>(relation, this.distanceFunction, this.k, this.share, this.rnd);
        }

        public static class Parameterizer<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            public static final OptionID SHARE_ID = new OptionID("randomknn.share", "The relative amount of objects to consider for kNN computations.");
            public static final OptionID SEED_ID = new OptionID("randomknn.seed", "The random number seed.");
            private double share = 0.0;
            private RandomFactory rnd;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                RandomParameter randomParameter;
                super.makeOptions(parameterization);
                DoubleParameter doubleParameter = new DoubleParameter(SHARE_ID);
                doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
                doubleParameter.addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
                if (parameterization.grab(doubleParameter)) {
                    this.share = (Double)doubleParameter.getValue();
                }
                if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                    this.rnd = (RandomFactory)randomParameter.getValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction, this.share, this.rnd);
            }
        }
    }
}

