/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class CachedDoubleDistanceKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private File filename;
    private static final Logging LOG = Logging.getLogger(CachedDoubleDistanceKNNPreprocessor.class);

    public CachedDoubleDistanceKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int n, File file) {
        super(relation, distanceFunction, n);
        this.filename = file;
    }

    @Override
    protected void preprocess() {
        this.createStorage();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.filename, "rw");
             FileChannel fileChannel = randomAccessFile.getChannel();){
            int n = randomAccessFile.readInt();
            if (n != -893108964) {
                throw new AbortException("Cache magic number does not match.");
            }
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 4L, randomAccessFile.length() - 4L);
            DBIDIter dBIDIter = this.relation.iterDBIDs();
            while (dBIDIter.valid()) {
                int n2 = ByteArrayUtil.readUnsignedVarint(mappedByteBuffer);
                int n3 = ByteArrayUtil.readUnsignedVarint(mappedByteBuffer);
                if (n3 < this.k) {
                    throw new AbortException("kNN cache contains fewer than k objects!");
                }
                KNNHeap kNNHeap = DBIDUtil.newHeap(this.k);
                for (int i = 0; i < n3; ++i) {
                    int n4 = ByteArrayUtil.readUnsignedVarint(mappedByteBuffer);
                    double d = mappedByteBuffer.getDouble();
                    kNNHeap.insert(d, DBIDUtil.importInteger(n4));
                }
                this.storage.put(DBIDUtil.importInteger(n2), kNNHeap.toKNNList());
                dBIDIter.advance();
            }
            if (mappedByteBuffer.hasRemaining()) {
                LOG.warning("kNN cache has " + mappedByteBuffer.remaining() + " bytes remaining!");
            }
        }
        catch (IOException iOException) {
            throw new AbortException("I/O error in loading kNN cache: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "cached-knn";
    }

    @Override
    public String getShortName() {
        return "cached-knn";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        private File filename;

        public Factory(int n, DistanceFunction<? super O> distanceFunction, File file) {
            super(n, distanceFunction);
            this.filename = file;
        }

        @Override
        public CachedDoubleDistanceKNNPreprocessor<O> instantiate(Relation<O> relation) {
            CachedDoubleDistanceKNNPreprocessor<O> cachedDoubleDistanceKNNPreprocessor = new CachedDoubleDistanceKNNPreprocessor<O>(relation, this.distanceFunction, this.k, this.filename);
            return cachedDoubleDistanceKNNPreprocessor;
        }

        public static class Parameterizer<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            public static final OptionID CACHE_ID = new OptionID("external.knnfile", "Filename with the precomputed k nearest neighbors.");
            private File filename;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                FileParameter fileParameter = new FileParameter(CACHE_ID, FileParameter.FileType.INPUT_FILE);
                if (parameterization.grab(fileParameter)) {
                    this.filename = (File)fileParameter.getValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction, this.filename);
            }
        }
    }
}

