/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfamilies;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.CosineDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.lsh.hashfamilies.LocalitySensitiveHashFunctionFamily;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.CosineLocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.SimplifiedRandomHyperplaneProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.LessEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;

@Reference(authors="M.S. Charikar", title="Similarity estimation techniques from rounding algorithms", booktitle="Proc. 34th ACM Symposium on Theory of computing, STOC'02", url="https://dx.doi.org/10.1145/509907.509965")
public class CosineHashFunctionFamily
implements LocalitySensitiveHashFunctionFamily<NumberVector> {
    private RandomProjectionFamily proj;
    private int k;

    public CosineHashFunctionFamily(int n, RandomFactory randomFactory) {
        this.proj = new SimplifiedRandomHyperplaneProjectionFamily(randomFactory);
        this.k = n;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public ArrayList<? extends LocalitySensitiveHashFunction<? super NumberVector>> generateHashFunctions(Relation<? extends NumberVector> relation, int n) {
        int n2 = RelationUtil.dimensionality(relation);
        ArrayList<CosineLocalitySensitiveHashFunction> arrayList = new ArrayList<CosineLocalitySensitiveHashFunction>(n);
        for (int i = 0; i < n; ++i) {
            RandomProjectionFamily.Projection projection = this.proj.generateProjection(n2, this.k);
            arrayList.add(new CosineLocalitySensitiveHashFunction(projection));
        }
        return arrayList;
    }

    @Override
    public boolean isCompatible(DistanceFunction<?> distanceFunction) {
        return distanceFunction instanceof CosineDistanceFunction;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("lsh.projection.random", "Random seed for generating the projections.");
        public static final OptionID NUMPROJ_ID = new OptionID("lsh.projection.projections", "Number of projections to use for each hash function.");
        RandomFactory random;
        int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            super.makeOptions(parameterization);
            RandomParameter randomParameter = new RandomParameter(RANDOM_ID);
            if (parameterization.grab(randomParameter)) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)((IntParameter)new IntParameter(NUMPROJ_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT)).addConstraint((ParameterConstraint)new LessEqualConstraint(32)))) {
                this.k = intParameter.intValue();
            }
        }

        @Override
        protected CosineHashFunctionFamily makeInstance() {
            return new CosineHashFunctionFamily(this.k, this.random);
        }
    }
}

