/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;

public abstract class AbstractRefiningIndex<O>
extends AbstractIndex<O> {
    private Counter refinements;

    public AbstractRefiningIndex(Relation<O> relation) {
        super(relation);
        Logging logging = this.getLogger();
        this.refinements = logging.isStatistics() ? logging.newCounter(this.getClass().getName() + ".refinements") : null;
    }

    public abstract Logging getLogger();

    protected void countRefinements(int n) {
        if (this.refinements != null) {
            this.refinements.increment(n);
        }
    }

    @Override
    public void logStatistics() {
        if (this.refinements != null) {
            this.getLogger().statistics(this.refinements);
        }
    }

    protected O refine(DBID dBID) {
        this.countRefinements(1);
        return this.relation.get(dBID);
    }

    public abstract class AbstractKNNQuery
    extends AbstractDistanceKNNQuery<O> {
        public AbstractKNNQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        protected double refine(DBIDRef dBIDRef, O o) {
            AbstractRefiningIndex.this.countRefinements(1);
            return this.distanceQuery.distance(o, dBIDRef);
        }

        protected void incRefinements(int n) {
            AbstractRefiningIndex.this.countRefinements(n);
        }
    }

    public abstract class AbstractRangeQuery
    extends AbstractDistanceRangeQuery<O> {
        public AbstractRangeQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        protected double refine(DBIDRef dBIDRef, O o) {
            AbstractRefiningIndex.this.countRefinements(1);
            return this.distanceQuery.distance(o, dBIDRef);
        }

        protected void incRefinements(int n) {
            AbstractRefiningIndex.this.countRefinements(n);
        }
    }
}

