/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public class SavedSettingsFile
implements Iterable<Pair<String, ArrayList<String>>> {
    public static final String COMMENT_PREFIX = "#";
    private File file;
    private ArrayList<Pair<String, ArrayList<String>>> store;

    public SavedSettingsFile(String string) {
        this.file = new File(string);
        this.store = new ArrayList();
    }

    public void save() throws FileNotFoundException {
        PrintStream printStream = new PrintStream(this.file);
        printStream.println("#Saved ELKI settings. First line is title, remaining lines are parameters.");
        for (Pair<String, ArrayList<String>> pair : this.store) {
            printStream.println((String)pair.first);
            for (String string : (ArrayList)pair.second) {
                printStream.println(string);
            }
            printStream.println();
        }
        printStream.close();
    }

    public void load() throws FileNotFoundException, IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
        ArrayList<String> arrayList = new ArrayList<String>();
        while (bufferedReader.ready()) {
            string = bufferedReader.readLine();
            if (string.startsWith(COMMENT_PREFIX)) continue;
            if (string.length() == 0 && arrayList.size() > 0) {
                String string2 = (String)arrayList.remove(0);
                this.store.add(new Pair(string2, arrayList));
                arrayList = new ArrayList();
                continue;
            }
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            string = (String)arrayList.remove(0);
            this.store.add(new Pair(string, arrayList));
            arrayList = new ArrayList();
        }
        bufferedReader.close();
    }

    @Override
    public Iterator<Pair<String, ArrayList<String>>> iterator() {
        return this.store.iterator();
    }

    public void remove(String string) {
        Iterator<Pair<String, ArrayList<String>>> iterator = this.store.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next().first;
            if (!string.equals(string2)) continue;
            iterator.remove();
            break;
        }
    }

    public ArrayList<String> get(String string) {
        for (Pair<String, ArrayList<String>> pair : this.store) {
            if (!string.equals(pair.first)) continue;
            return (ArrayList)pair.second;
        }
        return null;
    }

    public void clear() {
        this.store.clear();
    }

    public void put(String string, ArrayList<String> arrayList) {
        for (Pair<String, ArrayList<String>> pair : this.store) {
            if (!string.equals(pair.first)) continue;
            pair.second = arrayList;
            return;
        }
        this.store.add(new Pair<String, ArrayList<String>>(string, arrayList));
    }

    public int size() {
        return this.store.size();
    }

    public Pair<String, ArrayList<String>> getElementAt(int n) {
        return this.store.get(n);
    }
}

