/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.gui.util.DynamicParameters;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import javax.swing.table.AbstractTableModel;

public class ParametersModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Logging LOG = Logging.getLogger(ParametersModel.class);
    private DynamicParameters parameters;
    public static final String[] columns = new String[]{"Parameter", "Value"};

    public ParametersModel(DynamicParameters dynamicParameters) {
        this.parameters = dynamicParameters;
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public int getRowCount() {
        return this.parameters.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < this.parameters.size()) {
            DynamicParameters.Node node = this.parameters.getNode(n);
            if (n2 == 0) {
                return node;
            }
            if (n2 == 1) {
                String string = node.value;
                if (string == null) {
                    string = "";
                }
                return string;
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int n) {
        return columns[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return Parameter.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1 || n > this.parameters.size();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object instanceof String) {
            String string = (String)object;
            if (n2 == 1) {
                if (string.equals(this.parameters.getNode((int)n).value)) {
                    return;
                }
                if (("Default: " + string).equals(this.parameters.getNode((int)n).value)) {
                    return;
                }
                this.parameters.getNode((int)n).value = string;
                this.fireTableCellUpdated(n, n2);
            }
        } else {
            LOG.warning("Edited value is not a String!");
        }
    }
}

