/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep;

import de.lmu.ifi.dbs.elki.KDDTask;
import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.gui.GUIUtil;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.AlgorithmTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.EvaluationTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.InputTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.LoggingTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.OutputTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.SavedSettingsTabPanel;
import de.lmu.ifi.dbs.elki.gui.util.LogPanel;
import de.lmu.ifi.dbs.elki.gui.util.SavedSettingsFile;
import de.lmu.ifi.dbs.elki.logging.CLISmartHandler;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

@Alias(value={"multi", "multigui", "multistepgui"})
public class MultiStepGUI
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(MultiStepGUI.class);
    JFrame frame = new JFrame("ELKI ExpGUI");
    protected LogPanel outputArea;
    private InputTabPanel inputTab;
    private AlgorithmTabPanel algTab;
    private EvaluationTabPanel evalTab;
    private OutputTabPanel outTab;
    private LoggingTabPanel logTab;
    private SavedSettingsTabPanel setTab;

    public MultiStepGUI() {
        this.frame.setDefaultCloseOperation(2);
        try {
            this.frame.setIconImage(new ImageIcon(KDDTask.class.getResource("elki-icon.png")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame.setLayout(new GridBagLayout());
        this.outputArea = new LogPanel();
        JComponent jComponent = new JScrollPane(this.outputArea);
        jComponent.setPreferredSize(new Dimension(800, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.frame.add((Component)jComponent, gridBagConstraints);
        this.outputArea.becomeDefaultLogger();
        jComponent = new JTabbedPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.frame.add((Component)jComponent, gridBagConstraints);
        this.addPanels((JTabbedPane)jComponent);
        this.frame.pack();
    }

    private void addPanels(JTabbedPane jTabbedPane) {
        SavedSettingsFile savedSettingsFile = new SavedSettingsFile("MiniGUI-saved-settings.txt");
        try {
            savedSettingsFile.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.warning("Error loading saved settings.", fileNotFoundException);
        }
        catch (IOException iOException) {
            LOG.exception(iOException);
        }
        this.inputTab = new InputTabPanel();
        this.algTab = new AlgorithmTabPanel(this.inputTab);
        this.evalTab = new EvaluationTabPanel(this.inputTab, this.algTab);
        this.outTab = new OutputTabPanel(this.inputTab, this.evalTab);
        this.logTab = new LoggingTabPanel();
        this.setTab = new SavedSettingsTabPanel(savedSettingsFile, this);
        jTabbedPane.addTab("Input", this.inputTab);
        jTabbedPane.addTab("Algorithm", this.algTab);
        jTabbedPane.addTab("Evaluation", this.evalTab);
        jTabbedPane.addTab("Output", this.outTab);
        jTabbedPane.addTab("Logging", this.logTab);
        jTabbedPane.addTab("Saved Settings", this.setTab);
        this.setParameters(new ListParameterization());
    }

    public void setParameters(Parameterization parameterization) {
        this.logTab.setParameters(parameterization);
        this.inputTab.setParameters(parameterization);
        this.algTab.setParameters(parameterization);
        this.evalTab.setParameters(parameterization);
        this.outTab.setParameters(parameterization);
    }

    public ArrayList<String> serializeParameters() {
        ListParameterization listParameterization = new ListParameterization();
        this.logTab.appendParameters(listParameterization);
        this.inputTab.appendParameters(listParameterization);
        this.algTab.appendParameters(listParameterization);
        this.evalTab.appendParameters(listParameterization);
        this.outTab.appendParameters(listParameterization);
        return listParameterization.serialize();
    }

    @Override
    public void run() throws UnableToComplyException {
        this.frame.setVisible(true);
        this.outputArea.becomeDefaultLogger();
    }

    public static void main(final String[] stringArray) {
        GUIUtil.logUncaughtExceptions(LOG);
        GUIUtil.setLookAndFeel();
        OutputStep.setDefaultHandlerVisualizer();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MultiStepGUI multiStepGUI = new MultiStepGUI();
                    multiStepGUI.run();
                    if (stringArray != null && stringArray.length > 0) {
                        multiStepGUI.setParameters(new SerializedParameterization(stringArray));
                    } else {
                        multiStepGUI.setParameters(new SerializedParameterization());
                    }
                }
                catch (Error | Exception throwable) {
                    LoggingConfiguration.replaceDefaultHandler(new CLISmartHandler());
                    LOG.exception(throwable);
                }
            }
        });
    }
}

