/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

public class OutlierPrecisionRecallCurve
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(OutlierPrecisionRecallCurve.class);
    private Pattern positiveClassName;

    public OutlierPrecisionRecallCurve(Pattern pattern) {
        this.positiveClassName = pattern;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        XYCurve xYCurve;
        ArrayModifiableDBIDs arrayModifiableDBIDs;
        Database database = ResultUtil.findDatabase(resultHierarchy);
        SetDBIDs setDBIDs = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(database, this.positiveClassName));
        if (setDBIDs.size() == 0) {
            LOG.warning("Computing a P/R curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> list = ResultUtil.getOutlierResults(result);
        List<OrderingResult> list2 = ResultUtil.getOrderingResults(result);
        for (OutlierResult result2 : list) {
            arrayModifiableDBIDs = result2.getOrdering().order(result2.getOrdering().getDBIDs());
            xYCurve = this.computePrecisionResult(result2.getScores().size(), setDBIDs, arrayModifiableDBIDs.iter(), result2.getScores());
            database.getHierarchy().add(result2, xYCurve);
            list2.remove(result2.getOrdering());
        }
        for (OrderingResult orderingResult : list2) {
            arrayModifiableDBIDs = orderingResult.order(orderingResult.getDBIDs());
            xYCurve = this.computePrecisionResult(orderingResult.getDBIDs().size(), setDBIDs, arrayModifiableDBIDs.iter(), null);
            database.getHierarchy().add(orderingResult, xYCurve);
        }
    }

    private XYCurve computePrecisionResult(int n, SetDBIDs setDBIDs, DBIDIter dBIDIter, DoubleRelation doubleRelation) {
        int n2 = setDBIDs.size();
        int n3 = 0;
        int n4 = 0;
        PRCurve pRCurve = new PRCurve(n2 + 2, n2);
        double d = Double.NaN;
        while (dBIDIter.valid()) {
            block5: {
                double d2;
                double d3;
                block6: {
                    d3 = (double)n3 / (double)n4;
                    d2 = (double)n3 / (double)n2;
                    if (setDBIDs.contains(dBIDIter)) {
                        ++n3;
                    }
                    if (++n4 == 1) break block5;
                    if (doubleRelation == null) break block6;
                    double d4 = doubleRelation.doubleValue(dBIDIter);
                    if (Double.compare(d, d4) == 0) break block5;
                    d = d4;
                }
                pRCurve.addAndSimplify(d2, d3);
            }
            dBIDIter.advance();
        }
        pRCurve.addAndSimplify(1.0, n2 / n4);
        return pRCurve;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("precision.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (parameterization.grab(patternParameter)) {
                this.positiveClassName = (Pattern)patternParameter.getValue();
            }
        }

        @Override
        protected OutlierPrecisionRecallCurve makeInstance() {
            return new OutlierPrecisionRecallCurve(this.positiveClassName);
        }
    }

    public static class PRCurve
    extends XYCurve {
        public static final String PRAUC_LABEL = "PR-AUC";
        double auc = Double.NaN;
        int positive;

        public PRCurve(int n, int n2) {
            super("Recall", "Precision", n);
            this.positive = n2;
        }

        @Override
        public String getLongName() {
            return "Precision-Recall-Curve";
        }

        @Override
        public String getShortName() {
            return "pr-curve";
        }

        public double getAUC() {
            if (Double.isNaN(this.auc)) {
                double d = 1.0 - 1.0 / (double)this.positive;
                this.auc = PRCurve.areaUnderCurve(this) / d;
            }
            return this.auc;
        }

        @Override
        public void writeToText(TextWriterStream textWriterStream, String string) {
            textWriterStream.commentPrintLn("PR-AUC: " + this.getAUC());
            textWriterStream.flush();
            super.writeToText(textWriterStream, string);
        }
    }
}

