/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

public class OutlierPrecisionAtKCurve
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(OutlierPrecisionAtKCurve.class);
    private Pattern positiveClassName;
    private int maxk = Integer.MAX_VALUE;

    public OutlierPrecisionAtKCurve(Pattern pattern, int n) {
        this.positiveClassName = pattern;
        this.maxk = n;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        ArrayModifiableDBIDs arrayModifiableDBIDs;
        Database database = ResultUtil.findDatabase(resultHierarchy);
        SetDBIDs setDBIDs = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(database, this.positiveClassName));
        if (setDBIDs.size() == 0) {
            LOG.warning("Computing a ROC curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> list = ResultUtil.getOutlierResults(result);
        List<OrderingResult> list2 = ResultUtil.getOrderingResults(result);
        for (OutlierResult result2 : list) {
            arrayModifiableDBIDs = result2.getOrdering().order(result2.getOrdering().getDBIDs());
            database.getHierarchy().add(result2, this.computePrecisionResult(result2.getScores().size(), setDBIDs, arrayModifiableDBIDs));
            list2.remove(result2.getOrdering());
        }
        for (OrderingResult orderingResult : list2) {
            arrayModifiableDBIDs = orderingResult.order(orderingResult.getDBIDs());
            database.getHierarchy().add(orderingResult, this.computePrecisionResult(orderingResult.getDBIDs().size(), setDBIDs, arrayModifiableDBIDs));
        }
    }

    private XYCurve computePrecisionResult(int n, SetDBIDs setDBIDs, DBIDs dBIDs) {
        if (dBIDs.size() != n) {
            throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
        }
        int n2 = Math.min(n, this.maxk);
        PrecisionAtKCurve precisionAtKCurve = new PrecisionAtKCurve("k", "Precision", n2);
        int n3 = 0;
        DBIDIter dBIDIter = dBIDs.iter();
        for (int i = 1; i <= n2; ++i) {
            if (setDBIDs.contains(dBIDIter)) {
                ++n3;
            }
            precisionAtKCurve.addAndSimplify(i, (double)n3 / (double)i);
            dBIDIter.advance();
        }
        return precisionAtKCurve;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("precision.positive", "Class label for the 'positive' class.");
        public static final OptionID MAX_K_ID = new OptionID("precision.maxk", "Maximum value of 'k' to compute the curve up to.");
        private Pattern positiveClassName;
        private int maxk = Integer.MAX_VALUE;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (parameterization.grab(patternParameter)) {
                this.positiveClassName = (Pattern)patternParameter.getValue();
            }
            IntParameter intParameter = new IntParameter(MAX_K_ID);
            intParameter.setOptional(true);
            if (parameterization.grab(intParameter)) {
                this.maxk = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected OutlierPrecisionAtKCurve makeInstance() {
            return new OutlierPrecisionAtKCurve(this.positiveClassName, this.maxk);
        }
    }

    public static class PrecisionAtKCurve
    extends XYCurve {
        public PrecisionAtKCurve(String string, String string2, int n) {
            super("k", "Precision", n);
        }

        @Override
        public String getLongName() {
            return "Precision @ k Curve";
        }

        @Override
        public String getShortName() {
            return "precision-at-k";
        }

        @Override
        public void writeToText(TextWriterStream textWriterStream, String string) {
            textWriterStream.commentPrint(this.labelx);
            textWriterStream.commentPrint(" ");
            textWriterStream.commentPrint(this.labely);
            textWriterStream.flush();
            for (int i = 0; i < this.data.size(); i += 2) {
                textWriterStream.inlinePrint((int)this.data.get(i));
                textWriterStream.inlinePrint(this.data.get(i + 1));
                textWriterStream.flush();
            }
        }
    }
}

