/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments;

import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import java.util.Arrays;

public class Segment
implements Comparable<Segment> {
    public static final int UNCLUSTERED = -1;
    protected DBIDs objIDs = null;
    protected long pairsize = 0L;
    protected int[] clusterIds;

    public Segment(int n) {
        this.clusterIds = new int[n];
    }

    public long getPairCount() {
        return this.pairsize;
    }

    public Segment(int[] nArray) {
        this.clusterIds = nArray;
    }

    public int get(int n) {
        return this.clusterIds[n];
    }

    public boolean isUnpaired() {
        for (int n : this.clusterIds) {
            if (n != -1) continue;
            return true;
        }
        return false;
    }

    public boolean isNone() {
        for (int n : this.clusterIds) {
            if (n == -1) continue;
            return false;
        }
        return true;
    }

    public int getUnpairedClusteringIndex() {
        for (int i = 0; i < this.clusterIds.length; ++i) {
            if (this.clusterIds[i] != -1) continue;
            return i;
        }
        return -1;
    }

    public DBIDs getDBIDs() {
        return this.objIDs;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!Segment.class.isInstance(object)) {
            return false;
        }
        Segment segment = (Segment)object;
        return Arrays.equals(this.clusterIds, segment.clusterIds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.clusterIds);
    }

    @Override
    public int compareTo(Segment segment) {
        for (int i = 0; i < this.clusterIds.length; ++i) {
            int n = this.clusterIds[i];
            int n2 = segment.clusterIds[i];
            if (n == n2) continue;
            if (n * n2 > 0) {
                return n < n2 ? -1 : 1;
            }
            return n < n2 ? 1 : -1;
        }
        return 0;
    }
}

