/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.classification.holdout;

import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.RandomizedHoldout;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.TrainingAndTestSet;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Random;

public class RandomizedCrossValidation
extends RandomizedHoldout {
    protected int nfold;
    protected int fold;

    public RandomizedCrossValidation(RandomFactory randomFactory, int n) {
        super(randomFactory);
        this.nfold = n;
    }

    @Override
    public void initialize(MultipleObjectsBundle multipleObjectsBundle) {
        super.initialize(multipleObjectsBundle);
        this.fold = 0;
    }

    @Override
    public int numberOfPartitions() {
        return this.nfold;
    }

    @Override
    public TrainingAndTestSet nextPartitioning() {
        int n;
        int n2;
        if (this.fold >= this.nfold) {
            return null;
        }
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        Random random = this.random.getRandom();
        int n3 = this.bundle.dataLength();
        boolean[] blArray = new boolean[n3];
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < blArray.length; ++n2) {
            blArray[n2] = n = random.nextInt(this.nfold) < this.nfold - 1 ? 1 : 0;
            int n6 = n != 0 ? ++n4 : ++n5;
        }
        n = this.bundle.metaLength();
        for (n2 = 0; n2 < n; ++n2) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n4);
            ArrayList arrayList2 = new ArrayList(n5);
            for (int i = 0; i < n3; ++i) {
                (blArray[i] ? arrayList : arrayList2).add(this.bundle.data(i, n2));
            }
            multipleObjectsBundle.appendColumn(this.bundle.meta(n2), arrayList);
            multipleObjectsBundle2.appendColumn(this.bundle.meta(n2), arrayList2);
        }
        ++this.fold;
        return new TrainingAndTestSet(multipleObjectsBundle, multipleObjectsBundle2, this.labels);
    }

    public static class Parameterizer
    extends RandomizedHoldout.Parameterizer {
        public static final OptionID NFOLD_ID = new OptionID("nfold", "positive number of folds for cross-validation");
        public static final int N_DEFAULT = 10;
        protected int nfold;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)((IntParameter)new IntParameter(NFOLD_ID).setDefaultValue((Object)10)).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.nfold = intParameter.intValue();
            }
        }

        @Override
        protected RandomizedCrossValidation makeInstance() {
            return new RandomizedCrossValidation(this.random, this.nfold);
        }
    }
}

