/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.classification;

import de.lmu.ifi.dbs.elki.evaluation.classification.ConfusionMatrix;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;

public class ConfusionMatrixEvaluationResult
implements Result,
TextWriteable {
    private ConfusionMatrix confusionmatrix;
    private String evaluationName;

    public ConfusionMatrixEvaluationResult(ConfusionMatrix confusionMatrix, String string) {
        this.confusionmatrix = confusionMatrix;
        this.evaluationName = string;
    }

    @Override
    public void writeToText(TextWriterStream textWriterStream, String string) {
        textWriterStream.commentPrintLn("Evaluation:");
        textWriterStream.commentPrintLn(this.evaluationName);
        textWriterStream.commentPrintLn("Accuracy: \n  correctly classified instances: ");
        textWriterStream.commentPrintLn(this.confusionmatrix.truePositives());
        textWriterStream.commentPrintLn("true positive rate:         ");
        double d = this.confusionmatrix.truePositiveRate();
        textWriterStream.commentPrintLn(d);
        textWriterStream.commentPrintLn("false positive rate:        ");
        textWriterStream.commentPrintLn(this.confusionmatrix.falsePositiveRate());
        textWriterStream.commentPrintLn("positive predicted value:   ");
        double d2 = this.confusionmatrix.positivePredictedValue();
        textWriterStream.commentPrintLn(d2);
        textWriterStream.commentPrintLn("F1-measure:                 ");
        textWriterStream.commentPrintLn(2.0 * d2 * d / (d2 + d));
        textWriterStream.commentPrintLn("\nconfusion matrix:\n");
        textWriterStream.commentPrintLn(this.confusionmatrix.toString());
    }

    @Override
    public String getLongName() {
        return "confusionmatrixresult";
    }

    @Override
    public String getShortName() {
        return "confusionmatrixresult";
    }
}

